# -*- coding: utf-8 -*-

import re

from sandbox import sdk2
from sandbox.projects.yabs.auto_supbs_2.common import (
    BaseAutoSupBsIssueProcessor,
)
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditBudgetVersionedProcessor
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditCPCVersionedProcessor
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditCPMVersionedProcessor
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditAnyBudgetProcessor
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditCpcProcessor
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditBidsProcessor
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditCpmProcessor
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditFixCpmProcessor
from sandbox.projects.yabs.auto_supbs_2.lib.audit_processor_lib import AuditBidsClosedProcessor


timestamp_regex = r'timestamp\**\s*\**(\d+)\**\s*'
date_regex = r"(\d+-\d+-\d+)"


class AuditIssueProcessor(BaseAutoSupBsIssueProcessor):

    class Parameters(BaseAutoSupBsIssueProcessor.Parameters):
        yql_token = sdk2.parameters.String(
            'yql token sandbox vault name',
            default='AUTOSUPBS_YQL_TOKEN',
            required=True
        )


class AuditDailyBudgetVersionedIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        timestamp = re.findall(timestamp_regex, issue.description, re.UNICODE)
        audit_processor = AuditBudgetVersionedProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({
            'timestamp': timestamp[0],
            'available_spent_rate': '1.3',
        }))


class AuditBudgetVersionedIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        timestamp = re.findall(timestamp_regex, issue.description, re.UNICODE)
        audit_processor = AuditBudgetVersionedProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({
            'timestamp': timestamp[0],
            'available_spent_rate': '1.0',
        }))


class AuditCPCVersionedIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        timestamp = re.findall(timestamp_regex, issue.description, re.UNICODE)
        audit_processor = AuditCPCVersionedProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({'timestamp': timestamp[0]}))


class AuditCPMVersionedIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        timestamp = re.findall(timestamp_regex, issue.description, re.UNICODE)
        audit_processor = AuditCPMVersionedProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({'timestamp': timestamp[0]}))


class AuditAnyBudgetIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        timestamp = re.findall(timestamp_regex, issue.description, re.UNICODE)
        audit_processor = AuditAnyBudgetProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({'timestamp': timestamp[0]}))


class AuditCpcIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        timestamp = re.findall(timestamp_regex, issue.description, re.UNICODE)
        audit_processor = AuditCpcProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({'timestamp': timestamp[0]}))


class AuditCpmIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        timestamp = re.findall(timestamp_regex, issue.description, re.UNICODE)
        audit_processor = AuditCpmProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({'timestamp': timestamp[0]}))


class AuditBidsIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        date = re.findall(date_regex, issue.summary, re.UNICODE)
        audit_processor = AuditBidsProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({'date': date[0]}, issue))


class AuditBidsClosedIssueProcessor(AuditIssueProcessor):
    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        date = re.findall(date_regex, issue.summary, re.UNICODE)
        audit_processor = AuditBidsClosedProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )

        params = {
            'date': date[0],
            'abc_token': self.__get_abc_token(),
            'startrek_api_url': self.Parameters.startrek_api_url,
            'startrek_token': sdk2.Vault.data(self.owner, self.Parameters.startrek_token)
        }

        comment = audit_processor.process(params, issue)
        if comment:
            comments.append(comment)

    def __get_abc_token(self):
        return self.__get_token('abc_token')

    def __get_token(self, token_name):
        tokens = sdk2.yav.Secret("sec-01fx7jcsjevejnypw63tk26nj3").data()
        return tokens[token_name]


class AuditFixCPMIssueProcessor(AuditIssueProcessor):

    class Parameters(AuditIssueProcessor.Parameters):
        pass

    def process_issue(self, issue, comments):
        timestamp = re.findall(timestamp_regex, issue.description, re.UNICODE)
        audit_processor = AuditFixCpmProcessor(
            sdk2.Vault.data(self.owner, self.Parameters.yql_token),
        )
        comments.append(audit_processor.process({'timestamp': timestamp[0]}))
