# -*- coding: utf-8 -*-
# AuditAnyBudgetProcessor queries

audit_budget_versioned_processor_title1 = 'YQL Audit Budget Versioned 1'

audit_budget_versioned_processor_query1 = '''
    -- Check Daily AuditBudget
    USE hahn;

    $ToDatetime = ($ts) -> {{
        RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($ts AS Uint32)))
    }};

    $LocalizeDatetime = ($dt) -> {{
        RETURN DateTime::MakeTzDatetime(AddTimezone($dt, 'Europe/Moscow'))
    }};

    $ToLocalTzDatetime = ($ts) -> {{
        RETURN $LocalizeDatetime($ToDatetime($ts))
    }};

    $rubCurID = 643;

    $rubCompensationLimit = 300;

    $availableSpentRate = {available_spent_rate};

    -- Arguments:
    $runTimestamp = {timestamp};

    SELECT
        RunTime,
        LimitType,
        A.OrderID AS OrderID,
        $ToLocalTzDatetime(AutobudgetStartTime) AS AutobudgetStartTime,
        $ToLocalTzDatetime(PeriodStartTime) AS PeriodStartTime,
        $ToLocalTzDatetime(PeriodFinishTime) AS PeriodFinishTime,
        LimitBudget,
        LimitBudgetCur,
        Budget,
        BudgetCur,
        Exceed,
        ExceedCur,
        ExceedRate,
        ExceedCurRate,
        1.0 * (
            BudgetCur - LimitBudgetCur * $availableSpentRate
        ) * C.Ratio / 1000 / 1000 AS Compensation,
        IF(C.CurrencyID = $rubCurID, 1.0 * (
            BudgetCur - LimitBudgetCur * $availableSpentRate
        ) * C.Ratio / 1000 / 1000 > $rubCompensationLimit, NULL) AS IsCompensationNeeded,
        $ToLocalTzDatetime(FirstEvent) AS FirstEvent,
        $ToLocalTzDatetime(LastEvent) AS LastEvent,
    FROM
        `//home/yabs/autobudget/AuditBudget` AS A
    INNER JOIN
        `//home/yabs/dict/CaesarOrderInfo` AS O
    ON
        O.OrderID = A.OrderID
    INNER JOIN
        `//home/yabs/dict/Currency` AS C
    ON
        C.CurrencyID = O.CurrencyID
    WHERE
        RunTime = $runTimestamp
    ;
'''

audit_cpc_versioned_processor_title1 = 'YQL Audit CPC Versioned 1'

audit_cpc_versioned_processor_query1 = '''
    -- Select Audit CPC
    USE hahn;

    $ToDatetime = ($ts) -> {{
        RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($ts AS Uint32)))
    }};

    $LocalizeDatetime = ($dt) -> {{
        RETURN DateTime::MakeTzDatetime(AddTimezone($dt, 'Europe/Moscow'))
    }};

    $ToLocalTzDatetime = ($ts) -> {{
        RETURN $LocalizeDatetime($ToDatetime($ts));
    }};

    $GetAvailableExceedRate = ($clicks, $periodStartTime, $periodFinishTime) -> {{
        RETURN  IF($clicks < 100 OR ($ToDatetime($periodFinishTime) - $ToDatetime($periodStartTime)) < DateTime::IntervalFromDays(7), 2.0, 1.0)
    }};

    $rubCurID = 643;

    $rubCompensationLimit = 300;

    -- Arguments:
    $runTimestamp = {timestamp};

    SELECT
        RunTime,
        LimitType,
        A.OrderID AS OrderID,
        $ToLocalTzDatetime(AutobudgetStartTime) AS AutobudgetStartTime,
        $ToLocalTzDatetime(PeriodStartTime) AS PeriodStartTime,
        $ToLocalTzDatetime(PeriodFinishTime) AS PeriodFinishTime,
        LimitAvgCPC,
        LimitAvgCPCCur,
        AvgCPC,
        AvgCPCCur,
        LimitBudget,
        LimitBudgetCur,
        Budget,
        BudgetCur,
        Clicks,
        Exceed,
        ExceedCur,
        ExceedRate,
        ExceedCurRate,
        CurrencyCode,
        1.0 * (
            BudgetCur
            - Clicks * LimitAvgCPCCur * $GetAvailableExceedRate(Clicks, PeriodStartTime, PeriodFinishTime)
        ) * C.Ratio / 1000 / 1000 AS Compensation,
        IF(C.CurrencyID = $rubCurID, 1.0 * (
            BudgetCur
            - Clicks * LimitAvgCPCCur * $GetAvailableExceedRate(Clicks, PeriodStartTime, PeriodFinishTime)
        ) * C.Ratio / 1000 / 1000 > $rubCompensationLimit, NULL) AS IsCompensationNeeded,
        $ToLocalTzDatetime(FirstEvent) AS FirstEvent,
        $ToLocalTzDatetime(LastEvent) AS LastEvent,
    FROM
        `//home/yabs/autobudget/AuditCPC` AS A
    INNER JOIN
        `//home/yabs/dict/CaesarOrderInfo` AS O
    ON
        O.OrderID = A.OrderID
    INNER JOIN
        `//home/yabs/dict/Currency` AS C
    ON
        C.CurrencyID = O.CurrencyID
    WHERE
        RunTime = $runTimestamp
    ;
'''

audit_cpm_versioned_processor_title1 = 'YQL Audit CPM Versioned 1'

audit_cpm_versioned_processor_query1 = '''
    -- Select Audit CPM
    USE hahn;

    $ToDatetime = ($ts) -> {{
        RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($ts AS Uint32)))
    }};

    $LocalizeDatetime = ($dt) -> {{
        RETURN DateTime::MakeTzDatetime(AddTimezone($dt, 'Europe/Moscow'))
    }};

    $ToLocalTzDatetime = ($ts) -> {{
        RETURN $LocalizeDatetime($ToDatetime($ts));
    }};

    $GetAvailableExceedRate = ($shows, $periodFinishTime, $periodStartTme, $periodFinishTimeReal, $periodStartTmeReal) -> {{
        RETURN  IF(
            $shows < 10000
            OR (
                $periodFinishTime - $periodStartTmeReal
            ) < (
                $periodFinishTimeReal - $periodStartTme
            )
          , 2.0
          , 1.0
        )
    }};

    $rubCurID = 643;

    $rubCompensationLimit = 300;

    -- Arguments:
    $runTimestamp = {timestamp};

    SELECT
        RunTime,
        LimitType,
        OrderID,
        $ToLocalTzDatetime(AutobudgetStartTime) AS AutobudgetStartTime,
        $ToLocalTzDatetime(AutobudgetSoftRestartTime) AS AutobudgetSoftRestartTime,
        $ToLocalTzDatetime(PeriodStartTime) AS PeriodStartTime,
        $ToLocalTzDatetime(PeriodFinishTime) AS PeriodFinishTime,
        $ToLocalTzDatetime(PeriodStartTimeReal) AS PeriodStartTimeReal,
        $ToLocalTzDatetime(PeriodFinishTimeReal) AS PeriodFinishTimeReal,
        LimitAvgCPM,
        LimitAvgCPMCur,
        AvgCPM,
        AvgCPMCur,
        LimitBudget,
        LimitBudgetCur,
        Budget,
        BudgetCur,
        Shows,
        Exceed,
        ExceedCur,
        ExceedRate,
        ExceedCurRate,
        CurrencyCode,
        1.0 * (
            BudgetCur
            - Shows * LimitAvgCPMCur * $GetAvailableExceedRate(Shows, PeriodFinishTime, PeriodStartTime, PeriodFinishTimeReal, PeriodStartTimeReal)
        ) * C.Ratio / 1000 / 1000 AS Compensation,
        IF(C.CurrencyID = $rubCurID, 1.0 * (
            BudgetCur
            - Shows * LimitAvgCPMCur * $GetAvailableExceedRate(Shows, PeriodFinishTime, PeriodStartTime, PeriodFinishTimeReal, PeriodStartTimeReal)
        ) * C.Ratio / 1000 / 1000 > $rubCompensationLimit, NULL) AS IsCompensationNeeded,
        $ToLocalTzDatetime(FirstEvent) AS FirstEvent,
        $ToLocalTzDatetime(LastEvent) AS LastEvent,
    FROM
        `//home/yabs/autobudget/AuditCPMVersioned` AS A
    INNER JOIN
        `//home/yabs/dict/Currency` AS C
    ON
        C.CurrencyID = A.CurrencyID
    WHERE
        RunTime = $runTimestamp
    ;
'''

audit_any_budget_processor_title1 = 'YQL Audit Any Budget 1'

audit_any_budget_processor_query1 = '''
    USE hahn;
    pragma AutoCommit;
    -- check DAILY budget

    $runTime = {timestamp};

    $ab_current_run_tbl = 'tmp/ab_' || cast($runTime as string);

    insert into $ab_current_run_tbl WITH TRUNCATE
        select *
        from `//home/yabs/autobudget/AuditBudget`
        where RunTime = $runTime;
'''

audit_any_budget_processor_title2 = u'YQL Audit Any Budget 2'

audit_any_budget_processor_query2 = u'''
    USE hahn;
    pragma AutoCommit;
    -- check DAILY budget

    $runTime =  {timestamp};

    $ab_current_run_tbl = 'tmp/ab_' || cast($runTime as string);

    $date_format = DateTime::Format('%Y-%m-%d');
    $date_format2 = DateTime::Format('%Y-%m-%dT%H-%M-%S');

    /*
    insert into $ab_current_run_tbl WITH TRUNCATE
        select *
        from `//home/yabs/autobudget/AuditBudget`
        where RunTime = $runTime;
    */
$day = ($ts) -> {{
    return $date_format(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow'))
}};

$week = ($ts) -> {{
    return $date_format(DateTime::StartOfWeek(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow')))
}};

$fmt = ($ts) -> {{
    return $date_format2(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow'))
}};

$orders_checked = (
    select *
    from $ab_current_run_tbl
    where LimitBudgetCur < BudgetCur
        and FirstEvent between max_of(AutobudgetStartTime, PeriodStartTime) and PeriodFinishTime
        and LastEvent between max_of(AutobudgetStartTime, PeriodStartTime) and PeriodFinishTime
        and FirstEvent < LastEvent
        and (
            -- дневной FirstEvent, LastEvent в пределах одних суток
            (LimitType == 'daily' and $day(FirstEvent) == $day(LastEvent))
            or
            -- недельный и дневно-недельный FirstEvent, LastEvent в пределах одной календарной недели
            ((LimitType == 'week' or LimitType == 'daily-week') and $week(FirstEvent) == $week(LastEvent))
            or
            -- период FirstEvent, LastEvent в пределах периода
            (LimitType == 'period'
                and FirstEvent between PeriodStartTime and PeriodFinishTime
                and LastEvent between PeriodStartTime and PeriodFinishTime
            )
        )
);

SELECT * from $orders_checked;

$from = (select $day(min(FirstEvent)) from $orders_checked);
$to = (select $day(max(LastEvent)) from $orders_checked);

-- $ab_restarts = (
--     select OrderID, FirstEvent, LastEvent, count(*) as restarts
--         from range(`//logs/bs-abrestart-log/1d`, $from, $to) as r
--             join $orders_checked as o on Cast(r.orderid as Uint64) == o.OrderID
--         where cast(r.starttime as Uint64) > o.FirstEvent
--             and cast(r.starttime as Uint64) < o.LastEvent
--         group by o.OrderID as OrderID, o.FirstEvent as FirstEvent, o.LastEvent as LastEvent
--         -- примерное обрезание рестартов с
--         having COUNT_IF(reason <> 'new_moneydaylimit') > 0
-- );

-- $orders = (
--     select
--             OrderID as OrderID,
--             LimitType as LimitType,
--             LimitBudgetCur as LimitBudgetCur,
--             AutobudgetStartTime as AutobudgetStartTime,
--             PeriodStartTime as PeriodStartTime,
--             PeriodFinishTime as PeriodFinishTime,
--             FirstEvent as FirstEvent,
--             LastEvent as LastEvent
--         from $orders_checked as o
--             left only join $ab_restarts as ab using(OrderID, FirstEvent, LastEvent)
-- );  -- нет рестартов автобюджета в период FirstEvent LastEvent

-- SELECT * FROM $orders;


$child_orders = FROM
    `//home/yabs/dict/CaesarOrderInfo` AS oi
INNER JOIN
    $orders_checked AS o
ON
    oi.OrderID = o.OrderID
SELECT
    o.OrderID AS OrderID,
    LimitType as LimitType,
    LimitBudgetCur as LimitBudgetCur,
    AutobudgetStartTime as AutobudgetStartTime,
    PeriodStartTime as PeriodStartTime,
    PeriodFinishTime as PeriodFinishTime,
    FirstEvent as FirstEvent,
    LastEvent as LastEvent,
WHERE
    oi.OrderID <> oi.GroupOrderID
;

SELECT * FROM $child_orders;

$group_orders = FROM
    `//home/yabs/dict/CaesarOrderInfo` AS oi
INNER JOIN
    $orders_checked AS o
ON
    oi.OrderID = o.OrderID
SELECT
    o.OrderID AS OrderID,
    LimitType AS LimitType,
    LimitBudgetCur AS LimitBudgetCur,
    AutobudgetStartTime AS AutobudgetStartTime,
    PeriodStartTime AS PeriodStartTime,
    PeriodFinishTime AS PeriodFinishTime,
    FirstEvent AS FirstEvent,
    LastEvent AS LastEvent,
WHERE
    oi.OrderID = oi.GroupOrderID
;

SELECT * FROM $group_orders;

$stat = (
    select OrderID,
        FirstEvent,
        LastEvent,
        coalesce(sum_if(costcur, not stat.`autobudgetoptions_paid-actions`), 0) as costcur,
        count(*) as events -- billing events (for cpm, cpc calculation)
    from range(`//cooked_logs/bs-chevent-cooked-log/1d`, $from, $to) as stat
        join $child_orders as o on o.OrderID = stat.orderid
    where fraudbits == 0
        and ((placeid == 542 AND countertype == 2) OR (placeid == 1542 AND countertype == 1))
        and stat.eventtime between o.FirstEvent and o.LastEvent
    group by o.OrderID AS OrderID,
        o.FirstEvent as FirstEvent,
        o.LastEvent as LastEvent
    union all
    select OrderID,
        FirstEvent,
        LastEvent,
        coalesce(sum_if(costcur, not stat.`autobudgetoptions_paid-actions`), 0) as costcur,
        count(*) as events -- billing events (for cpm, cpc calculation)
    from range(`//cooked_logs/bs-chevent-cooked-log/1d`, $from, $to) as stat
        join $group_orders as o on o.OrderID = stat.grouporderid
    where fraudbits == 0
        and ((placeid == 542 AND countertype == 2) OR (placeid == 1542 AND countertype == 1))
        and stat.eventtime between o.FirstEvent and o.LastEvent
        and stat.`autobudgetoptions_limit-group-daily-budget`
    group by o.OrderID AS OrderID,
        o.FirstEvent as FirstEvent,
        o.LastEvent as LastEvent
);

SELECT * FROM $stat;

$max_day_limit = FROM
    `//home/yabs/dict/CaesarAutoBudgetOrderWithHistory` AS a
INNER JOIN
    $orders_checked AS o
ON
    a.OrderID = o.OrderID
SELECT
    OrderID,
    StartTime,
    MAX_BY(MaxLimitDayMoney, LastUpdateTime) AS MaxLimitDayMoney,
    MAX_BY(MaxLimitDayMoneyCur, LastUpdateTime) AS MaxLimitDayMoneyCur,
WHERE
    LimitType = 'daily'
    AND a.LastUpdateTime < o.PeriodStartTime
GROUP BY
    a.OrderID AS OrderID, a.StartTime AS StartTime, o.LimitType AS LimitType
;

$max_day_limit = FROM
    $max_day_limit AS A
LEFT JOIN (
    FROM
        `//home/yabs/dict/CaesarAutoBudgetOrderWithHistory` AS a
    INNER JOIN
        $orders_checked AS o
    ON
        a.OrderID == o.OrderID
    SELECT
        OrderID,
        StartTime,
        MAX(LimitDayMoney) AS MaxLimitDayMoney,
        MAX(LimitDayMoneyCur) AS MaxLimitDayMoneyCur,
    WHERE
        LimitType = 'daily'
        AND $day(a.LastUpdateTime) = $day(o.PeriodStartTime)
    GROUP BY
        a.OrderID AS OrderID, a.StartTime AS StartTime, o.LimitType AS LimitType
) AS B
ON
    A.OrderID = B.OrderID AND A.StartTime = B.StartTime
SELECT
    A.OrderID AS OrderID,
    A.StartTime AS StartTime,
    MAX_OF(A.MaxLimitDayMoney, COALESCE(B.MaxLimitDayMoney, 0)) AS MaxLimitDayMoney,
    MAX_OF(A.MaxLimitDayMoneyCur, COALESCE(B.MaxLimitDayMoneyCur, 0)) AS MaxLimitDayMoneyCur,
;

$max_day_limit = FROM
    $max_day_limit
SELECT
    OrderID,
    MAX(StartTime) AS StartTime,
    MAX_BY(MaxLimitDayMoney, StartTime) AS MaxLimitDayMoney,
    MAX_BY(MaxLimitDayMoneyCur, StartTime) AS MaxLimitDayMoneyCur,
GROUP BY
    OrderID
;

SELECT * FROM $max_day_limit;

$check = (
    select o.OrderID as OrderID,
            o.LimitType as LimitType,
            o.FirstEvent as FirstEvent,
            o.LastEvent as LastEvent,
            s.events as EventsCnt,
            s.costcur as CostCur,
            o.LimitBudgetCur as LimitBudgetCur,
            mdl.MaxLimitDayMoneyCur as MaxLimitDayMoneyCur,
            (100. * s.costcur) / o.LimitBudgetCur - 100 as ExceedRate,
            (o.LimitBudgetCur >= s.costcur or (o.LimitType == 'daily' and (1.3 * nvl(MaxLimitDayMoneyCur, o.LimitBudgetCur)) >= s.costcur)) as IsGood
        from $stat as s
            join $orders_checked as o on o.OrderID == s.OrderID and o.FirstEvent = s.FirstEvent and o.LastEvent = s.LastEvent
            left join $max_day_limit as mdl on mdl.OrderID = o.OrderID
);

SELECT * FROM $check;

$tbl = ('//home/bs/users/audit/ab-budget_' || cast($runTime as String));

insert into $tbl with truncate
    select * from $check;


-- проблемные заказы

$pre_true =
(
select OrderID,
        LimitType,
        $fmt(FirstEvent) as FirstEvent,
        $fmt(LastEvent) as LastEvent,
        EventsCnt,
        CostCur,
        LimitBudgetCur,
        MaxLimitDayMoneyCur,
        ExceedRate
    from $check
    where not IsGood
);

select
    pt.OrderID as OrderID,
    LimitType,
    FirstEvent,
    LastEvent,
    EventsCnt,
    CostCur,
    LimitBudgetCur,
    MaxLimitDayMoneyCur,
    ExceedRate,
    c.CurrencyCode as CurrencyCode,
    1.0 * (CostCur - LimitBudgetCur) * c.Ratio / 1000 / 1000 as Compensation,
    1.0 * (CostCur - LimitBudgetCur) * c.Ratio * if(oi.CurrencyID = 0, 30.0, cast(cr.Rate as float)) / 1000 / 1000 > 300 as IsCompensationNeeded
from
    $pre_true as pt
inner join
    `home/yabs/dict/CaesarOrderInfo` as oi -- узнаём валюту заказа
on
    pt.OrderID == oi.OrderID
inner join
    `home/yabs/dict/Currency` as c -- необходимо для получения Ratio
on
    oi.CurrencyID == c.CurrencyID
left join -- left, потому что можем встретить CurrencyID = 0
    `home/yabs/dict/CurrencyRates` as cr -- необходима для получения актуального курса валют
on
    oi.CurrencyID == cr.CurrencyID
where
    cr.EventDate = (($runTime / 24 / 3600) * 24 * 3600 - (3 * 3600)) -- используем курс на дату проверки аудита, функция преобразовывает unix-время к началу дня по Москве
order by
    OrderID, FirstEvent
into result `true-cases`;

-- ложные срабатывания

select OrderID,
        LimitType,
        $fmt(FirstEvent) as FirstEvent,
        $fmt(LastEvent) as LastEvent,
        EventsCnt,
        CostCur,
        LimitBudgetCur,
        MaxLimitDayMoneyCur,
        ExceedRate
    from $check
    where IsGood
    order by
        OrderID, FirstEvent
    into result `false-cases`;

/*
некорректные срабатывания мониторинга:
- выброка событий вне периода управлния автобюджетом;
- некорректный период;
- не проверялось ограничение в валюте;
*/
select mon.OrderID, mon.FirstEvent, mon.LastEvent,
        not (
            FirstEvent between max_of(AutobudgetStartTime, PeriodStartTime) and PeriodFinishTime
            and
            LastEvent between max_of(AutobudgetStartTime, PeriodStartTime) and PeriodFinishTime
        ) as notInRange
from (
        select *
        from `//home/yabs/autobudget/AuditBudget`
            where RunTime = $runTime
    ) as mon
    left only join $orders_checked as valid using(OrderID, AutobudgetStartTime, PeriodStartTime, PeriodFinishTime, FirstEvent, LastEvent)
    into result `invalid-cases`;
'''

# AuditCpcProcessor queries

audit_cpc_processor_title1 = u'YQL Audit CPC 1'

audit_cpc_processor_query1 = u'''
    USE hahn;

    -- check CPC

    $runTime = {timestamp};

    $ab_current_run_tbl = 'tmp/ab_cpc_' || cast($runTime as string);

    $date_format = DateTime::Format('%Y-%m-%d');
    $date_format2 = DateTime::Format('%Y-%m-%dT%H-%M-%S');

    $day = ($ts) -> {{
        return $date_format(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow'))
    }};

    $week = ($ts) -> {{
        return $date_format(DateTime::StartOfWeek(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow')))
    }};

    $fmt = ($ts) -> {{
        return $date_format2(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow'))
    }};

    INSERT INTO $ab_current_run_tbl WITH TRUNCATE
        select *
        from `//home/yabs/autobudget/AuditCPC`
        where RunTime = $runTime
            and LimitAvgCPCCur < AvgCPCCur
            and FirstEvent between max_of(AutobudgetStartTime, PeriodStartTime) and PeriodFinishTime
            and LastEvent between max_of(AutobudgetStartTime, PeriodStartTime) and PeriodFinishTime
            and FirstEvent < LastEvent
            and (
                (LimitType == 'daily' and $day(FirstEvent) == $day(LastEvent)) -- дневной FirstEvent, LastEvent в пределах одних суток
                or
                (LimitType == 'week' and $week(FirstEvent) == $week(LastEvent)) -- недельный FirstEvent, LastEvent в пределах одной календарной недели
                or
                (LimitType == 'period'
                    and FirstEvent between PeriodStartTime and PeriodFinishTime
                    and LastEvent between PeriodStartTime and PeriodFinishTime
                ) -- период FirstEvent, LastEvent в пределах периода
            )
'''


audit_cpc_processor_title2 = u'YQL Audit CPC 2'

audit_cpc_processor_query2 = u'''
    USE hahn;

    -- check CPC

    $runTime = {timestamp};

    $ab_current_run_tbl = 'tmp/ab_cpc_' || cast($runTime as string);

    $date_format = DateTime::Format('%Y-%m-%d');
    $date_format2 = DateTime::Format('%Y-%m-%dT%H-%M-%S');

    $day = ($ts) -> {{
        return $date_format(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow'))
    }};

    $week = ($ts) -> {{
        return $date_format(DateTime::StartOfWeek(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow')))
    }};

    $fmt = ($ts) -> {{
        return $date_format2(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow'))
    }};

    $orders_checked = (
        select *
        from $ab_current_run_tbl
    );

    $from = (select $day(min(FirstEvent)) from $orders_checked);
    $to = (select $day(max(LastEvent)) from $orders_checked);

    $ab_restarts = (
        select OrderID, FirstEvent, LastEvent, count(*) as restarts
            from range(`//logs/bs-abrestart-log/1d`, $from, $to) as r
                join $orders_checked as o on Cast(r.orderid as Uint64) == o.OrderID
            where cast(r.starttime as Uint64) > o.FirstEvent
                and cast(r.starttime as Uint64) < o.LastEvent
            group by o.OrderID as OrderID, o.FirstEvent as FirstEvent, o.LastEvent as LastEvent
            having count(*) > 0
    );

    $orders = (
        select
                OrderID as OrderID,
                LimitType as LimitType,
                LimitAvgCPCCur as LimitAvgCPCCur,
                AutobudgetStartTime as AutobudgetStartTime,
                PeriodStartTime as PeriodStartTime,
                PeriodFinishTime as PeriodFinishTime,
                FirstEvent as FirstEvent,
                LastEvent as LastEvent
            from $orders_checked as o
                left only join $ab_restarts as ab using(OrderID, FirstEvent, LastEvent)
    );  -- нет рестартов автобюджета в период FirstEvent LastEvent

    $stat = (
        select OrderID,
            FirstEvent,
            LastEvent,
            sum(costcur) as costcur,
            count(*) as events -- billing events (for cpm, cpc calculation)
        from range(`//cooked_logs/bs-chevent-cooked-log/1d`, $from, $to) as stat
            join $orders as o on o.OrderID = stat.orderid
        where fraudbits == 0
            and ((placeid == 542 AND countertype == 2) OR (placeid == 1542 AND countertype == 1))
            and stat.eventtime between o.FirstEvent and o.LastEvent
        group by o.OrderID as OrderID,
            o.FirstEvent as FirstEvent,
            o.LastEvent as LastEvent
    );

    $check = (
        select o.OrderID as OrderID,
                o.LimitType as LimitType,
                $fmt(o.FirstEvent) as FirstEvent,
                $fmt(o.LastEvent) as LastEvent,
                s.events as EventsCnt,
                s.costcur as CostCur,
                (cast(s.costcur as Double) / s.events) as AvgCPCCur,
                o.LimitAvgCPCCur as LimitAvgCPCCur,
                (100. * (cast(s.costcur as Double) / s.events)) / o.LimitAvgCPCCur - 100 as ExceedRate,
                (1.04 * LimitAvgCPCCur > (cast(s.costcur as Double) / s.events) or s.events <= 100) as IsGood
            from $stat as s
                join $orders as o using(OrderID, FirstEvent, LastEvent)
    );

    -- проблемные заказы

    select OrderID,
            LimitType,
            FirstEvent,
            LastEvent,
            EventsCnt,
            AvgCPCCur,
            LimitAvgCPCCur,
            ExceedRate
        from $check
        where not IsGood
        order by
            OrderID, FirstEvent
        into result `true-cases`;

    -- ложные срабатывания

    select OrderID,
            LimitType,
            FirstEvent,
            LastEvent,
            EventsCnt,
            AvgCPCCur,
            LimitAvgCPCCur,
            ExceedRate
        from $check
        where IsGood
        order by
            OrderID, FirstEvent
        into result `false-cases`;

    /*
    некорректные срабатывания мониторинга:
    - выброка событий вне периода управлния автобюджетом;
    - некорректный период;
    - не проверялось ограничение в валюте;
    - рестарты автобюджета в периоде выборки
    */

    select *
    from (
            select *
            from `//home/yabs/autobudget/AuditCPC`
                where RunTime = $runTime
        ) as mon
        left only join $orders as valid using(OrderID, AutobudgetStartTime, PeriodStartTime, PeriodFinishTime, FirstEvent, LastEvent)
        into result `invalid-cases`;
'''


# AuditBidsProcessor queries

audit_bids_processor_title1 = u'YQL Audit Bids'

audit_bids_processor_query1 = u'''
    pragma yt.MaxRowWeight = "128M";

    $date = "{date}";

    use hahn;

    $date_parse = DateTime::Parse('%Y-%m-%dT%H:%M:%SZ');

    $full_result = (
    select
        A.*,
        cast(A.EventCost as float) / A.SourceCost * A.SourceCostCur as EventCostCurEstimated,
        A.RealCostCur*1.0/A.SourceCostCur as multiplier_with_bidcorrection,
        A.RealCostCur*1.0/A.SourceCostCur/A.FinalBidCorrection as multiplier_without_bidcorrection,
        A.RealCostCur*1.0/A.ABMaxCostCur as multiplier_with_AB,
        DateTime::ToMicroseconds(AddTimeZone(DateTime::MakeDatetime($date_parse(A.ShowTime)), 'Europe/Moscow')) as STMos
    from
        (select * from `//home/yabs/stat/AuditBids` where ShowTime like $date || '%') as A
    where
        A.BannerID < Math::Pow(2,39) -- https://st.yandex-team.ru/SUPBS-14676#5f3a7815906dfe3b4267e6ea - неправильно наследуются корректировки для дочерних смарт-баннеров
        AND not (A.UserCoefTypesAsString like '%expr-traffic-jam%' or A.OTS > 1000000) -- https://st.yandex-team.ru/BSDEV-77676
        AND A.ab_segment_multiplier > 0 --https://st.yandex-team.ru/BSSERVER-14218
        AND not (A.UserCoefTypesAsString like '%expr-weather%' and A.ExportID in (17081660, 37904974,37905689)) --https://st.yandex-team.ru/BSSERVER-10606
    );

    --temporary until L3AA not in logs
    $full_result_with_hit = (
        select
            f.*,
            c.hitlogid as hitlogid,
            c.usercoefvaluetotal as usercoefvaluetotal,
        from
            range(`logs/bs-chevent-log/1h`, $date || "T00:00:00", $date || "T23:00:00") as c
            inner join $full_result as f
            on cast(f.LogID as String) = c.logid and cast(f.OrderID as String) = c.orderid);

    $full_result_with_metawide = (
        select
            h.*,
            m.L3AntiAlzheimer as L3AntiAlzheimer
        from
            $full_result_with_hit as h
            inner join range(`logs/bs-proto-metawide-log/1h`, $date || "T00:00:00", $date || "T23:00:00") as m
            on cast(h.hitlogid as uint64) = m.HitLogID and h.BannerID = m.BannerID);

    $full_result = (
        select *
        from $full_result_with_metawide
        where L3AntiAlzheimer == 1000000);

    select * from $full_result order by OrderID, LogID, ShowTime
    into result `full result`;

    select a.*, e.directmultipliertypes from $full_result as a
        join like(`logs/bs-chevent-log/1h`, $date || '%') as e on cast(e.logid as Uint64) == a.LogID
    where e.directmultipliertypes ?? '' != ''
    into result `ESS`;

    select
        cid,
        login,
        link,
        count(*) as errors_count
    from
        $full_result as R
    join
        `//home/direct/db/campaigns` as C
    on
        R.ExportID = C.cid
    join
        `//home/direct/db/users` as U
    on
        C.ClientID = U.ClientID
    where
        U.rep_type = 'chief'
    group by
        R.ExportID as cid,
        U.login as login,
        'https://direct.yandex.ru/dna/log/?ulogin=' || CAST(U.login as String) || '&cid=' || CAST(R.ExportID as String) as link
    order by cid
    into result `direct campaigns`;
'''

# AuditCpmProcessor queries

audit_cpm_processor_title1 = u'YQL Audit CPM 1'

audit_cpm_processor_query1 = u'''
    USE hahn;

    -- check CPM

    $runTime =  {timestamp};

    $date_format = DateTime::Format('%Y-%m-%d');
    $date_format2 = DateTime::Format('%Y-%m-%dT%H-%M-%S');
    $day = ($ts) -> {{
        return $date_format(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow'))
    }};

    $week = ($ts) -> {{
        return $date_format(DateTime::StartOfWeek(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow')))
    }};

    $fmt = ($ts) -> {{
        return $date_format2(AddTimezone(DateTime::MakeDatetime(DateTime::FromSeconds(cast($ts as Uint32))), 'Europe/Moscow'))
    }};


    $orders_checked = (
        select *
        from `//home/yabs/autobudget/AuditCPM`
        where RunTime = $runTime
            and LimitAvgCPMCur < AvgCPMCur
            and FirstEvent between max_of(AutobudgetStartTime, PeriodStartTime) and PeriodFinishTime
            and LastEvent between max_of(AutobudgetStartTime, PeriodStartTime) and PeriodFinishTime
            and FirstEvent < LastEvent
            and (
                (LimitType == 'daily' and $day(FirstEvent) == $day(LastEvent)) -- дневной FirstEvent, LastEvent в пределах одних суток
                or
                (LimitType == 'week' and $week(FirstEvent) == $week(LastEvent)) -- недельный FirstEvent, LastEvent в пределах одной календарной недели
                or
                (LimitType == 'period'
                    and FirstEvent between PeriodStartTime and PeriodFinishTime
                    and LastEvent between PeriodStartTime and PeriodFinishTime
                ) -- период FirstEvent, LastEvent в пределах периода
            )
    );

    $from = (select $day(min(FirstEvent)) from $orders_checked);
    $to = (select $day(max(LastEvent)) from $orders_checked);

    $ab_restarts = (
        select OrderID, FirstEvent, LastEvent, count(*) as restarts
            from range(`//logs/bs-abrestart-log/1d`, $from, $to) as r
                join $orders_checked as o on Cast(r.orderid as Uint64) == o.OrderID
            where cast(r.starttime as Uint64) > o.FirstEvent
                and cast(r.starttime as Uint64) < o.LastEvent
            group by o.OrderID as OrderID, o.FirstEvent as FirstEvent, o.LastEvent as LastEvent
            having count(*) > 0
    );

    $orders = (
        select
                OrderID as OrderID,
                LimitType as LimitType,
                LimitAvgCPMCur as LimitAvgCPMCur,
                AutobudgetStartTime as AutobudgetStartTime,
                PeriodStartTime as PeriodStartTime,
                PeriodFinishTime as PeriodFinishTime,
                FirstEvent as FirstEvent,
                LastEvent as LastEvent
            from $orders_checked as o
                left only join $ab_restarts as ab using(OrderID, FirstEvent, LastEvent)
    );  -- нет рестартов автобюджета в период FirstEvent LastEvent

    $stat = (
        select OrderID,
            FirstEvent,
            LastEvent,
            sum(costcur) as costcur,
            count(*) as events -- billing events (for cpm, cpc calculation)
        from range(`//cooked_logs/bs-chevent-cooked-log/1d`, $from, $to) as stat
            join $orders as o on o.OrderID = stat.orderid
        where fraudbits == 0
            and ((placeid == 542 AND countertype == 2) OR (placeid == 1542 AND countertype == 1))
            and stat.eventtime between o.FirstEvent and o.LastEvent
        group by o.OrderID as OrderID,
            o.FirstEvent as FirstEvent,
            o.LastEvent as LastEvent
    );

    $check = (
        select o.OrderID as OrderID,
                o.LimitType as LimitType,
                $fmt(o.FirstEvent) as FirstEvent,
                $fmt(o.LastEvent) as LastEvent,
                s.events as EventsCnt,
                s.costcur as CostCur,
                (cast(s.costcur as Double) / s.events) as AvgCPMCur,
                o.LimitAvgCPMCur as LimitAvgCPMCur,
                (100. * (cast(s.costcur as Double) / s.events)) / o.LimitAvgCPMCur - 100 as ExceedRate,
                (1.04 * LimitAvgCPMCur > (cast(s.costcur as Double) / s.events) or s.events <= 10000) as IsGood
            from $stat as s
                join $orders as o using(OrderID, FirstEvent, LastEvent)
    );

    -- проблемные заказы

    select OrderID,
            LimitType,
            FirstEvent,
            LastEvent,
            EventsCnt,
            AvgCPMCur,
            LimitAvgCPMCur,
            ExceedRate
        from $check
        where not IsGood
        order by
            OrderID, FirstEvent
        into result `true-cases`;

    -- ложные срабатывания

    select OrderID,
            LimitType,
            FirstEvent,
            LastEvent,
            EventsCnt,
            AvgCPMCur,
            LimitAvgCPMCur,
            ExceedRate
        from $check
        where IsGood
        order by
            OrderID, FirstEvent
        into result `false-cases`;

    /*
    некорректные срабатывания мониторинга:
    - выброка событий вне периода управлния автобюджетом;
    - некорректный период;
    - не проверялось ограничение в валюте;
    - рестарты автобюджета в периоде выборки
    */

    select *
    from (
            select *
            from `//home/yabs/autobudget/AuditCPM`
                where RunTime = $runTime
        ) as mon
        left only join $orders as valid using(OrderID, AutobudgetStartTime, PeriodStartTime, PeriodFinishTime, FirstEvent, LastEvent)
        into result `invalid-cases`;
'''

# AuditFixCpmProcessor queries

audit_fix_cpm_processor_title1 = u'YQL Audit fix-CPM 1'

audit_fix_cpm_processor_query1 = u'''
USE hahn;
-- Check Fix-CPM audit

$ToDatetime = ($ts) -> {{
    RETURN DateTime::MakeDatetime(DateTime::FromSeconds(CAST($ts AS Uint32)))
}};

$LocalizeDatetime = ($dt) -> {{
    RETURN DateTime::MakeTzDatetime(AddTimezone($dt, 'Europe/Moscow'))
}};

$ToLocalTzDatetime = ($ts) -> {{
    RETURN $LocalizeDatetime($ToDatetime($ts))
}};

-- Arguments:
$runTimestamp = {timestamp};

SELECT
    RunTime,
    OrderID,
    LogID,
    $ToLocalTzDatetime(EventTime) AS EventTime,
    SourceCost,
    RealCost,
    InitCost,
    EventCost,
    SourceCostCur,
    RealCostCur,
    EventCostCur,
    InitCostTaxFree,
    CostTaxFree,
FROM
    `//home/yabs/autobudget/AuditFixCPM`
WHERE
    RunTime = $runTimestamp
;
'''
