# -*- coding: utf-8 -*-

import logging
import requests
import json
from textwrap import dedent


class DistributionProcessor():

    def __init__(self, yql_token):
        self.yql_token = yql_token

    def process(self, start_date, end_date, yandexuid, is_mobile, pages, orders, url):
        message = []

        #  message.append(self.__add_profile_info(yandexuid, int(is_mobile)))
        if url is not None:
            message.append(self.__add_count_link(url))
        banana_orders, result = self.__add_bs_chevent_cooked_log(
            start_date=start_date,
            end_date=end_date,
            yandexuid=yandexuid,
            orders=orders,
            pages=pages,
        )
        message.append(result)
        if banana_orders:
            message.append(self.__add_banana_links(banana_orders))
        if not int(is_mobile):
            message.append(self.__add_export_access_log(yandexuid))

        return message

    def __add_profile_info(self, yandexuid, is_mobile):
        title = '1. BigB-profile'
        if is_mobile:
            keywords = '395,723'
        else:
            keywords = '509'
        bigb_request = 'http://bigb-fast.yandex.ru:80/bigb?bigb-uid={yandexuid}&keywords={keywords}&pretty=1'.format(
            yandexuid=yandexuid,
            keywords=keywords,
        )
        r = requests.get(bigb_request)
        logging.info('Response from BigB with status code: %s, text: %s', r.status_code, r.text)
        return '**{title}**\n<{{profile\n%%{request}\n{response}\n%%}}>'.format(
            title=title,
            request=bigb_request,
            response=str(json.dumps(r.json(), indent=1)),
        )

    def __add_count_link(self, url):
        title = '2. YQL Count-link'
        query_body = '''
            select
                Yabs::FilterRecord("{url}")
        '''.format(
            url=url
        )
        return '**{title}**\n{body}'.format(
            title=title,
            body=self.__return_yql_link(query_body, query_title=title),
        )

    def __add_bs_chevent_cooked_log(self, start_date, end_date, yandexuid, orders, pages):
        title = '3. YQL bs-chevent-cooked-log'

        def obtain_order_and_page(order_id, page_id):
            order_line = '''
                and orderid in ({})
            '''.format(str(orders))
            page_line = '''
                and pageid in ({})
            '''.format(str(pages))
            if orders and pages:
                return '{}\n{}'.format(order_line, page_line)
            elif order_id:
                return order_line
            elif page_id:
                return page_line
            else:
                return ''

        query_body = '''
            use hahn;
            $yandexuid = {yandexuid};
            select
                * from range(`cooked_logs/bs-chevent-cooked-log/1d`, `{start_date}`, `{end_date}`)
            where
                uniqid = $yandexuid
                and phraseid = 9
                {order_and_page_query}
            order by
                bannerid, eventtime
        '''.format(
            start_date=start_date,
            end_date=end_date,
            yandexuid=yandexuid,
            order_and_page_query=obtain_order_and_page(orders, pages),
        )
        query_link, result = self.__return_yql_result(query_body, title)
        orders = set()
        if result is not None:
            for row in result:
                orders.add(row['orderid'])
        return list(orders), '**{title}**\n{body}'.format(
            title=title,
            body=query_link,
        )

    def __add_banana_links(self, orders):
        title = '4. Banana-link'
        links = []
        for order_id in orders:
            links.append('https://banana.yandex-team.ru/#/search?search={}&orders'.format(order_id))

        return '**{title}**\n{links}'.format(
            title=title,
            links='\n'.join(links),
        )

    def __add_export_access_log(self, yandexuid):
        title = '5. YQL export-access-log'
        query_body = '''
            use hahn;
            select
                yasoft, min(`timestamp`) as min_timestamp, max(`timestamp`) as max_timestamp
            from
                like(`//statbox/export-access-log`, '2020-%')
            where
                raw_yandexuid = '{yandexuid}'
            group by
                Url::GetCGIParam(request, 'yasoft') as yasoft;

        '''.format(
            yandexuid=yandexuid,
        )
        return '**{title}**\n{body}'.format(
            title=title,
            body=self.__return_yql_link(query_body, query_title=title),
        )

    def __return_yql_link(self, query_body, query_title='YQL autosupbs-distribution'):
        query = self.__run_yql(query_body, query_title)
        if not query.is_success:
            return 'Failed to run\n{}'.format(query.share_url)
        return query.share_url

    def __return_yql_result(self, query_body, query_title='YQL autosupbs-distribution'):
        from yql.util.type_visitors import construct_cell
        from yql.util.type_processors import PythonReadObjectsProcessor

        query = self.__run_yql(query_body, query_title)
        if not query.is_success:
            return query.share_url, None
        tables = list(query.get_results())
        table = tables[0]
        processor = PythonReadObjectsProcessor()
        final_result = []
        for row in table.get_iterator():
            result = {}
            for column_name, column_type, value in zip(table.column_names, table.column_types, row):
                result[column_name] = construct_cell(value, column_type, processor=processor)
            final_result.append(result)
        return query.share_url, final_result

    def __run_yql(self, query_body, query_title):
        from yql.api.v1.client import YqlClient

        yql_client = YqlClient(token=self.yql_token)
        yql_client.config.pass_token_to_yt = True
        query = yql_client.query(
            dedent(query_body).decode('utf-8'),
            title=query_title,
            syntax_version=1,
        )
        query.run()
        logging.info('Executing YQL query: {}'.format(query_body))
        query.wait_progress()
        return query
