# -*- coding: utf-8 -*-
import requests


def check_yql_process(operation_id, yql_token):
    headers = {
        'Authorization': 'OAuth ' + yql_token,
        'Content-type': 'application/json',
        'Accept': 'application/json',
    }
    response = requests.get(
        url='https://yql.yandex-team.ru/api/v2/operations/{operation_id}/meta'.format(operation_id=operation_id),
        headers=headers,
    )
    if response.json()['status'] == 'ERROR':
        raise Exception('YQL Operation has failed: operation_id:{}'.format(operation_id))
    elif response.json()['status'] == 'COMPLETED':
        return True
    else:
        return False


def get_matching_funnel_yql_query(ticket_id, order_id, page_id, imp_id, date_from, date_to, yql_result_root):
    from library.python import resource
    import logging

    query = resource.find('/lifeorder_yql_template')
    auction_query = resource.find('/lifeorder_auction_yql_template')

    result_path = '{root}/{ticket_id}/{order_id}/'.format(root=yql_result_root, ticket_id=ticket_id, order_id=order_id)
    logging.info(result_path)

    additional_yql_where_clause = ''
    if page_id is not None:
        additional_yql_where_clause = "and pageid = '{}'".format(page_id)
        if imp_id is not None:
            additional_yql_where_clause += " and impid = '{}'".format(imp_id)
    logging.info(additional_yql_where_clause)

    query = query.format(result_path=result_path, order_id=order_id, date_from=date_from, date_to=date_to, additional_yql_where_clause=additional_yql_where_clause)
    auction_query = auction_query.format(result_path=result_path, order_id=order_id, date_from=date_from, date_to=date_to, additional_yql_where_clause=additional_yql_where_clause)

    return query, auction_query


def get_result_path(ticket_id, order_id, yql_result_root, file_name):
    result_path = '{root}/{ticket_id}/{order_id}/1.1_{file_name}'.format(root=yql_result_root, ticket_id=ticket_id,
                                                                         order_id=order_id, file_name=file_name)
    return result_path


def get_chyt_analyzer_query(ticket_id, order_id, yql_result_root):
    from library.python import resource
    template = '/lifeorder_chyt_analyze_with_dates_yql_template'
    result_path = get_result_path(ticket_id, order_id, yql_result_root, "match")
    query = resource.find(template).format(result_table_path=result_path)
    return query


def get_auction_top_competitors_analyzer_query(ticket_id, order_id, yql_result_root, top_competitors):
    from library.python import resource
    template = '/lifeorder_auction_top_competitors_yql_template'
    result_path = get_result_path(ticket_id, order_id, yql_result_root, "auction_match")
    query = resource.find(template).format(result_table_path=result_path, order_id=order_id,
                                           top_competitors=top_competitors)
    return query


def get_auction_analyzer_query(ticket_id, order_id, yql_result_root, select_percentiles):
    from library.python import resource
    template = '/lifeorder_auction_analyze_yql_template'
    result_path = get_result_path(ticket_id, order_id, yql_result_root, "auction_match")
    query = resource.find(template).format(result_table_path=result_path, select_percentiles=select_percentiles)
    return query


def make_yql_running_message(order_id, page_id, imp_id, date_from, date_to, share_url1, share_url2):
    message = ["Maching funnel calculation is started", "OrderID={}".format(order_id)]
    if page_id:
        message.append('PageID: {}'.format(page_id))
        if imp_id:
            message.append('ImpID: {}'.format(imp_id))
    message.append("{}  -  {}".format(date_from, date_to))
    message.append(share_url1)
    message.append(share_url2)
    return message


def get_yql_title(order_id, page_id, imp_id, date_from, date_to):
    return 'matching funnel OrderID: {}, {}-{}, {} - {}'.format(order_id, page_id, imp_id, date_from, date_to)
