# coding=UTF-8
from __future__ import print_function
import time

from sandbox import sdk2

from sandbox.projects.yabs.autocampaign.utils.sandbox_tools import download_resource_file
from sandbox.sdk2.helpers import subprocess


class YabsAutocampaignCreator(sdk2.Task):
    """ Create or update autocampaign record in database """
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        max_restarts = 1
        description = "Creating autocampaigns %s" % time.strftime("%Y-%m-%d %H:%M:%S")

        with sdk2.parameters.Group("Autocampaign parameters") as autocampaign_parameters:

            domains = sdk2.parameters.String("List of domains to create", required=True, multiline=True)
            check_hold = sdk2.parameters.Bool("Check hold", default=False)
            vital_query = sdk2.parameters.Bool("Vital query", default=False)

            parent_region_id = sdk2.parameters.Integer("Parent Region Id", required=True, default=None)
            method = sdk2.parameters.String("Method to execute",
                                            choices=[
                                                ("update", "update"),
                                                ("create", "create"),
                                                ("delete", "delete")
                                            ],
                                            default="create")

        with sdk2.parameters.Group("Vault") as vault:
            yt_token = sdk2.parameters.String(
                label="YT token vault name",
                name="yt_token",
                default="YABS_AUTOCAMPAIGN_YT_TOKEN",
                required=True,
            )

        with sdk2.parameters.Group("Testing") as testing:
            testing_mode = sdk2.parameters.Bool(
                label="Testing mode",
                name="testing_mode",
                default=False
            )

            with testing_mode.value[True]:
                yt_proxy = sdk2.parameters.String("yt_proxy", default="igorock.haze.yandex.net:15562")

    def run(self):
        ad_stencil2 = download_resource_file(resource_name="ad_stencil2")
        yt_token = sdk2.Vault.data(self.Parameters.yt_token)

        command = [
            ad_stencil2,
            self.Parameters.method,
            " ".join([d for d in self.Parameters.domains.replace(",", " ").replace(";", " ").split()]),

            "--vital-query" if self.Parameters.vital_query else "",
            "--check-hold" if self.Parameters.check_hold else "",
            "--parent-region-id %d" % self.Parameters.parent_region_id,
            "--yt-token \"%s\"" % yt_token
        ]

        if self.Parameters.testing_mode:
            command += [
                "--stats-yt-proxy %s" % self.Parameters.yt_proxy
            ]

        with sdk2.helpers.ProcessLog(self, logger="ad_stencil") as pl:
            pl.logger.propagate = 1
            subprocess.Popen(unicode(" ".join(command)), shell=True, stdout=pl.stdout, stderr=pl.stderr).wait()

    def on_execute(self):
        self.run()
