from sandbox import sdk2
import logging


def download_resource_file(**kwargs):
    resource = sdk2.Resource.find(
        attrs=dict(**kwargs)
    ).order(-sdk2.Resource.id).first()

    if resource:
        logging.info("Found resource #%i" % resource.id)
        return str(sdk2.ResourceData(resource).path)
    else:
        raise Exception("Resource with params %s does not exists!" % ", ".join(["%s=%s" % (str(k), str(v)) for k, v in kwargs.items()]))
