from sandbox import sdk2
from sandbox.projects.yabs.base_bin_task import BaseBinTask


class YabsAvpExporter(BaseBinTask):
    """ YABS_AVP_EXPORTER """

    class Requirements(BaseBinTask.Requirements):
        ram = 2 << 10  # 2 GiB
        disk_space = 2 << 10  # 2 GiB
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(BaseBinTask.Parameters):
        with BaseBinTask.Parameters.version_and_task_resource() as version_and_task_resource:
            resource_attrs = sdk2.parameters.Dict('Filter resource by', default={'name': 'YabsAvpExporter'})

        # plaform parameters
        with sdk2.parameters.Group('Verification platform') as platform_params:
            platform_id = sdk2.parameters.String("Platform ID", required=True)
            platform_name = sdk2.parameters.String("Platform name", required=True)
            cookie_sync_table = sdk2.parameters.String("Cookie sync table", required=True)

        # yt parameters
        with sdk2.parameters.Group('YT connection') as yt_params:
            yt_cluster = sdk2.parameters.String("YT cluster", required=True)
            yt_token_secret = sdk2.parameters.YavSecret("YT token", description="YAV secret ID, key yt_token and yql_token", required=True)
            yt_path = sdk2.parameters.String("YT logs path", required=True)
            yt_workdir = sdk2.parameters.String("YT workdir", required=True, default="//tmp")

        # clickhouse parameters
        with sdk2.parameters.Group('ClickHouse connection') as clickhouse_params:
            ch_host = sdk2.parameters.String("ClickHouse host", required=True)
            ch_database = sdk2.parameters.String("ClickHouse database", required=True)
            ch_user = sdk2.parameters.String("ClickHouse user", required=True)
            ch_password_secret = sdk2.parameters.YavSecret("ClickHouse password", description="YAV secret ID, key ch_password", required=True)

        # clickhouse tables parameters
        with sdk2.parameters.Group('ClickHouse tables') as tables_params:
            tables_prefix = sdk2.parameters.String("Tables prefix", description="Tables prefix", required=True)
            keep_tables_count = sdk2.parameters.Integer("Keep tables", description="count", required=True)
            keep_processed_logs_records_days = sdk2.parameters.Integer("Keep processed_logs records", description="days", required=True)
            bulk_insert_rows_count = sdk2.parameters.Integer("Bulk insert rows count", description="rows", required=True)
            uid_salt = sdk2.parameters.String("YandexUID salt", required=True)
            custom_fields = sdk2.parameters.List("Custom fields", required=True)

    def on_execute(self):
        yt_token = self.Parameters.yt_token_secret.data()["yt_token"]
        yql_token = self.Parameters.yt_token_secret.data()["yql_token"]
        ch_password = self.Parameters.ch_password_secret.data()["ch_password"]

        from . import exporter

        avp_exporter = exporter.AvpExporter(
            platform_id=self.Parameters.platform_id,
            platform_name=self.Parameters.platform_name,

            yt_cluster=self.Parameters.yt_cluster,
            yt_token=yt_token.encode("utf-8"),
            yql_token=yql_token.encode("utf-8"),
            yt_log_path=self.Parameters.yt_path,
            yt_workdir=self.Parameters.yt_workdir,

            cookie_sync_table=self.Parameters.cookie_sync_table,

            ch_host=self.Parameters.ch_host,
            ch_database=self.Parameters.ch_database,
            ch_user=self.Parameters.ch_user,
            ch_password=ch_password,

            tables_prefix=self.Parameters.tables_prefix,
            keep_tables_count=self.Parameters.keep_tables_count,
            keep_processed_logs_records_days=self.Parameters.keep_processed_logs_records_days,

            bulk_insert_rows_count=self.Parameters.bulk_insert_rows_count,

            custom_fields=self.Parameters.custom_fields,
            uid_salt=self.Parameters.uid_salt,
        )

        avp_exporter.do()
