from sandbox import sdk2
from sandbox.projects.yabs.base_bin_task import BaseBinTask


class YabsMakeTnsLog(BaseBinTask):
    """ YABS_MAKE_TNS_LOG """

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 8072
        disk_space = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(BaseBinTask.Parameters):
        with BaseBinTask.Parameters.version_and_task_resource() as version_and_task_resource:
            resource_attrs = sdk2.parameters.Dict('Filter resource by', default={'name': 'YabsMakeTnsLog'})

        with sdk2.parameters.Group('Script arguments') as ch_params:
            platform_id = sdk2.parameters.String(
                "platform_id",
                description="Verification platform ID",
                required=True,
            )
            secret_name = sdk2.parameters.YavSecret(
                "yav secret id",
                required=True,
                description='secret should contain keys: s3_mds_access_secret_key s3_mds_access_key_id yt_token yql_token')

    def on_execute(self):
        secret = self.Parameters.secret_name
        yt_token = secret.data()["yt_token"]
        yql_token = secret.data()["yql_token"]
        mds_secret_access_key = secret.data()["s3_mds_access_secret_key"]
        mds_access_key_id = secret.data()["s3_mds_access_key_id"]

        from . import make_tns_log as make_tns
        log_handler = make_tns.VerifyLogsHandler(
            platform_id=self.Parameters.platform_id,
            mds_secret_key=mds_secret_access_key,
            mds_access_key_id=mds_access_key_id,
            yt_token=yt_token,
            yql_token=yql_token,
        )

        log_handler.create_new_logs()
        log_handler.copy_logs_to_mds_and_clear_mds()
