from sandbox import sdk2
from sandbox.common.types.misc import DnsType
from sandbox.sandboxsdk import environments
from datetime import datetime, timedelta

from .handler import YabsAwapsAuditLogExportHandler


class YabsAwapsAuditLogExportTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):

        default_log_date = datetime.now() - timedelta(days=1)
        log_date = sdk2.parameters.String("Log date", default=default_log_date.strftime("%Y-%m-%d"))
        log_date_finish = sdk2.parameters.String("Log date finish")

        yt_cluster = sdk2.parameters.String("YT cluster", default="hahn", required=True)
        yt_path = sdk2.parameters.String("YT path", default="//statbox/cube/archives/awaps-audited", required=True)
        yt_yav_secret = sdk2.parameters.YavSecret("YT token yav secret id",
                                                  required=True,
                                                  description='secret should contain keys: '
                                                              'yt_token ')

        sql_yav_secret = sdk2.parameters.YavSecret("SQL Archive Database yav secret id",
                                                   required=True,
                                                   description='secret should contain keys: '
                                                               'sql_host '
                                                               'sql_username '
                                                               'sql_password')

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment("pymssql", version="2.1.4"),
            environments.PipEnvironment('sqlalchemy', version="1.3.23"),
        )
        dns = DnsType.DNS64

    def on_execute(self):
        sql_secret_data = self.Parameters.sql_yav_secret.data()
        yt_secret_data = self.Parameters.yt_yav_secret.data()
        log_date = datetime.strptime(self.Parameters.log_date, "%Y-%m-%d") \
            if self.Parameters.log_date \
            else datetime.now() - timedelta(days=1)

        export_handler = YabsAwapsAuditLogExportHandler(
            yt_cluster=self.Parameters.yt_cluster,
            yt_path=self.Parameters.yt_path,
            yt_token=yt_secret_data["yt_token"],
            sql_host=sql_secret_data["sql_host"],
            sql_username=sql_secret_data["sql_username"],
            sql_password=sql_secret_data["sql_password"],
        )

        log_date_finish = datetime.strptime(self.Parameters.log_date_finish, "%Y-%m-%d") \
            if self.Parameters.log_date_finish \
            else None

        if log_date_finish:
            while log_date <= log_date_finish:
                export_handler.export(log_date)
                log_date += timedelta(days=1)
        else:
            export_handler.export(log_date)
