from sandbox import sdk2
from sandbox.common.types.misc import DnsType
from sandbox.sandboxsdk import environments

from .adjust import YabsAwapsCassandraAdjust


class YabsAwapsCassandraAdjustTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        mode = sdk2.parameters.String("Mode", default='check', required=True)
        sql_yav_secret = sdk2.parameters.YavSecret("SQL Archive Database yav secret id",
                                                   required=True,
                                                   description='secret should contain keys: '
                                                               'sql_host '
                                                               'sql_username '
                                                               'sql_password')

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment("pymssql", version="2.1.4"),
            environments.PipEnvironment("sqlalchemy"),
            environments.PipEnvironment("cassandra-driver"),
        )
        dns = DnsType.DNS64

    def on_execute(self):
        sql_secret_data = self.Parameters.sql_yav_secret.data()
        mode = self.Parameters.mod \
            if self.Parameters.mode \
            else 'check'

        adjust = YabsAwapsCassandraAdjust(
            sql_host=sql_secret_data["sql_host"],
            sql_username=sql_secret_data["sql_username"],
            sql_password=sql_secret_data["sql_password"],

        )

        adjust.process(mode)
