from sandbox import sdk2
from sandbox.common.types.misc import DnsType
from sandbox.sandboxsdk import environments

from .handler import YabsAwapsExportYtHandler


class YabsAwapsExportYt(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):

        sql_host = sdk2.parameters.String("SQL Host")
        sql_database = sdk2.parameters.String("SQL Database")
        sql_tables = sdk2.parameters.String("SQL Tables")
        sql_yav_secret = sdk2.parameters.YavSecret("SQL Database yav secret id",
                                                   required=True,
                                                   description='secret should contain keys: '
                                                               'sql_username '
                                                               'sql_password')

        yt_cluster = sdk2.parameters.String("YT cluster", default="hahn", required=True)
        yt_path = sdk2.parameters.String("YT path", default="//home/awaps/db", required=True)
        yt_yav_secret = sdk2.parameters.YavSecret("YT token yav secret id",
                                                  required=True,
                                                  description='secret should contain keys: '
                                                              'yt_token ')

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment("pymssql", version="2.1.4"),
            environments.PipEnvironment('sqlalchemy', version="1.3.23"),
        )
        dns = DnsType.DNS64

    def on_execute(self):
        sql_secret_data = self.Parameters.sql_yav_secret.data()
        yt_secret_data = self.Parameters.yt_yav_secret.data()

        export_handler = YabsAwapsExportYtHandler(
            yt_cluster=self.Parameters.yt_cluster,
            yt_path=self.Parameters.yt_path,
            yt_token=yt_secret_data["yt_token"],
            sql_host=self.Parameters.sql_host,
            sql_database=self.Parameters.sql_database,
            sql_username=sql_secret_data["sql_username"],
            sql_password=sql_secret_data["sql_password"],
        )

        for sql_table in self.Parameters.sql_tables.split(","):
            export_handler.export(sql_table)
