from sandbox import sdk2
from sandbox.projects.common.binary_task import LastBinaryTaskRelease, LastBinaryReleaseParameters
from sandbox.projects.common.yc.common.helpers import prepare_certs


class YabsServerSqlExecute(LastBinaryTaskRelease, sdk2.Task):
    description = 'Execute SQL query in specified db'

    class Parameters(LastBinaryReleaseParameters):
        with sdk2.parameters.Group('Databse connection'):
            host = sdk2.parameters.String('Database hostname')
            port = sdk2.parameters.Integer('Database port', default=6432)
            db_name = sdk2.parameters.String('Database name')
            user_name = sdk2.parameters.String('Database user')
        with sdk2.parameters.Group('Password'):
            password_secret = sdk2.parameters.YavSecret("Yav secret with database password")
            password_secret_key = sdk2.parameters.String("Password key in the yav secret", default="password")
        with sdk2.parameters.Group('Sql'):
            query = sdk2.parameters.String('SQL query to execute', multiline=True)

    @property
    def password(self):
        return self.Parameters.password_secret.data().get(self.Parameters.password_secret_key)

    def get_connection_pool(self):
        from psycopg2.pool import SimpleConnectionPool
        return SimpleConnectionPool(
            minconn=1,
            maxconn=2,
            host=self.Parameters.host,
            port=self.Parameters.port,
            database=self.Parameters.db_name,
            user=self.Parameters.user_name,
            password=self.password,
            sslmode='verify-full',
        )

    def on_execute(self):
        prepare_certs()
        pool = self.get_connection_pool()
        conn = pool.getconn()
        cursor = conn.cursor()
        cursor.execute(self.Parameters.query)
        conn.commit()
        self.set_info(cursor.statusmessage)
        cursor.close()
        pool.putconn(conn)
