# -*- coding: utf-8 -*-

import logging
import json

import sandbox.common.types.task as ctt

import sandbox.projects.common.yabs.server.db.utils as dbutils

from sandbox.projects.common.yabs.server.db import yt_bases

from sandbox.projects.yabs.qa.utils import yt_utils
from sandbox.projects.yabs.qa.utils.general import get_yt_path_html_hyperlink

from sandbox.projects.yabs.bases.YabsServerBasesFetch import YabsServerBasesFetch, ReuseFetchResults, FETCH_PREFIX_KEY, FETCH_OUTPUTS_KEY, FETCH_OUTPUTS_ATTR


logger = logging.getLogger(__name__)


class YabsServerBasesFetchTest(YabsServerBasesFetch):

    type = 'YABS_SERVER_BASES_FETCH_TEST'

    def on_enqueue(self):
        self.semaphores(ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name=self.YT_POOL_FETCH_SEMAPHORE, weight=3)
            ]
        ))

    def on_execute(self):
        from yt.wrapper import YtClient

        self.check_and_wait_tasks()

        yt_token = self.get_yt_token()  # Fail fast if no token available
        yt_client = YtClient(proxy=yt_bases.YT_PROXY, token=yt_token)

        dbs_to_generate = self.get_db_list()

        try_reuse_fetch_results = all((
            self.ctx.get(ReuseFetchResults.name),
            not self.oneshot_path
        ))

        fetch_prefix, fetch_output = self._try_reuse_fetch_results(dbs_to_generate, yt_client) if try_reuse_fetch_results else (None, None)

        if not (fetch_prefix and fetch_output):
            logging.info('Will not reuse fetch results')
            self._prepare_data(dbs_to_generate)
            self._modify_tables(yt_token)
            fetch_prefix, fetch_output = self._execute_yabscs(yt_token, yt_client, dbs_to_generate)
        else:
            yt_utils.set_yt_node_ttl(fetch_prefix, yt_bases.FETCH_OUTPUT_TTL, yt_client)
            logging.info('Set TLL for node %s: %s', fetch_prefix, yt_bases.FETCH_OUTPUT_TTL)

        self.ctx[FETCH_PREFIX_KEY] = fetch_prefix
        self.ctx[FETCH_OUTPUTS_KEY] = fetch_output

    def _try_reuse_fetch_results(self, dbs_to_generate, yt_client):
        filter_attributes = {
            yt_bases.BIN_DBS_NAMES_ATTR: dbs_to_generate,
            yt_bases.MYSQL_ARCHIVE_ATTR: self.mysql_archive_contents,
            yt_bases.INPUT_ARCHIVE_ATTR: self.input_spec_res_id,
            yt_bases.IS_REUSABLE_ATTR: True,
            yt_bases.SETTINGS_SPEC_MD5_ATTR: dbutils.calc_combined_settings_md5(self.cs_settings_archive_res_id, self.cs_settings_patch_res_id, self.settings_spec),
            yt_bases.CS_FETCH_VER_ATTR: self.cs_fetch_ver
        }
        logging.info('Search fetch results to reuse. Filter nodes by attributes: %s',
                     json.dumps(filter_attributes, indent=2))
        node_to_reuse = yt_bases.find_node_to_reuse(yt_client, yt_bases.FETCH_ROOT, check_task_status=False, filter_attributes=filter_attributes, add_attributes=[FETCH_OUTPUTS_ATTR])
        if node_to_reuse:
            self.node_to_reuse = node_to_reuse['$value']
            logger.info('Found fetch results to reuse: node %s with attributes %s',
                        self.node_to_reuse, node_to_reuse['$attributes'])
            self.set_info('Reuse fetch results from node {}'
                          .format(get_yt_path_html_hyperlink(proxy=yt_bases.YT_PROXY, path=self.node_to_reuse)),
                          do_escape=False)
            return self.node_to_reuse, node_to_reuse['$attributes'][FETCH_OUTPUTS_ATTR]
        else:
            logging.info('Not found fetch results to reuse')

        return None, None
