from sandbox.common.types.task import Semaphores
from sandbox.projects.common.utils import get_or_default
from sandbox.projects.common.yabs.server.db import yt_bases
from sandbox.projects.common.yabs.server.db.task.cs import YtPool
from sandbox.projects.yabs.bases.YabsServerBasesReduce import YabsServerBasesReduce


class YabsServerBasesReduceTest(YabsServerBasesReduce):
    type = 'YABS_SERVER_BASES_REDUCE_TEST'

    def setup_semaphores(self):
        yt_pool = get_or_default(self.ctx, YtPool)
        if yt_pool == yt_bases.YT_POOL:
            semaphores = [
                Semaphores.Acquire(name=self.YT_POOL_REDUCE_SEMAPHORE, weight=3)
            ]
        else:
            semaphores = [
                Semaphores.Acquire(name=yt_pool, weight=3)
            ]

        self.semaphores(Semaphores(acquires=semaphores))
