import logging
from collections import defaultdict
from jinja2 import Environment


logger = logging.getLogger(__name__)


REPORT_TEMPLATE = '''<div style="white-space: normal;">
{%- for (is_reused, parent_task_type, parent_task_id), children_resources in resources.items() -%}
    <h2>
        {{ 'Reused from' if is_reused else 'Generated by' }} {{ parent_task_type }}
        <a
            href="https://sandbox.yandex-team.ru/task/{{ parent_task_id }}/view"
            target="_blank"
        >
            #{{ parent_task_id }}
        </a>
    </h2>
    {%- for (child_task_type, child_task_id), bases in children_resources.items() -%}
        <h3>
            {{ production_method }} {{ child_task_type }}
            <a
                href="https://sandbox.yandex-team.ru/task/{{ child_task_id }}/view"
                target="_blank"
            >
                #{{ child_task_id }}
            </a>
        </h3>
        {% for tag, resource_id in bases|sort -%}
            {{ tag }}
            <a
                href="https://sandbox.yandex-team.ru/resource/{{ resource_id }}/view"
                target="_blank"
            >
                {{ resource_id }}
            </a>{{ '' if loop.last else ', ' }}
        {%- endfor %}
    {%- endfor %}
{%- endfor %}
</div>'''


def create_base_generation_report(base_generation_info, task_id):
    resources = defaultdict(dict)
    for item in base_generation_info:
        is_reused = item.base_generation_task_id != task_id
        base_generation_task_key = (is_reused, item.base_generation_task_type, item.base_generation_task_id)
        producing_task_key = (item.producing_task_type, item.producing_task_id)
        if producing_task_key not in resources[base_generation_task_key]:
            resources[base_generation_task_key][producing_task_key] = []
        resources[base_generation_task_key][producing_task_key].append((item.base_tag, item.resource_id))
    logger.debug('Resources: %s', resources)

    env = Environment()
    template = env.from_string(REPORT_TEMPLATE)
    return template.render(resources=resources)
