import logging
import random
import time

logger = logging.getLogger()


def retried(max_retries=5, initial_timeout=120, sleep=True, exceptions=tuple()):
    def wrapper(func):
        def wrapped(*args, **kwargs):
            if 'retry_pause' in kwargs:
                raise ValueError("Argument 'retry_pause' is not allowed in function under @retry")

            n = 0
            while True:
                timeout = (0.9 + 0.2 * random.random()) * initial_timeout * (1 << n)
                kwargs['timeout'] = timeout

                try:
                    return func(*args, **kwargs)
                except exceptions:
                    if n >= max_retries:
                        raise
                    logger.exception("Retrying %s with timeout %s%s", func.__name__, timeout, ', will first sleep for the same time' if sleep else '')
                    if sleep:
                        time.sleep(timeout)
                    n += 1

        return wrapped
    return wrapper
