from sandbox import sdk2
from sandbox.projects.yabs.base_bin_task import BaseBinTask


class BigbBstrAdapter(BaseBinTask):
    """ BIGB_BSTR_ADAPTER """

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(BaseBinTask.Parameters):
        kill_timeout = 10 * 60

        with BaseBinTask.Parameters.version_and_task_resource() as version_and_task_resource:
            resource_attrs = sdk2.parameters.Dict('Filter resource by', default={'name': 'BigbBstrAdapter'})

        # yt parameters
        with sdk2.parameters.Group('YT') as yt_params:
            yt_cluster = sdk2.parameters.String("Cluster", default="locke", required=True)
            yt_token_secret = sdk2.parameters.YavSecret("Token", required=True)
            yt_bigb_path = sdk2.parameters.String("BigB path", required=True)
            yt_bstr_path = sdk2.parameters.String("BSTR path", required=True)

        # adapter parameters
        with sdk2.parameters.Group('Adapter') as adapter_params:
            multi_versions_mode = sdk2.parameters.Bool("Multi versions mode", description="Use separate directory for each version", default=False, required=True)
            versions_count = sdk2.parameters.Integer("Versions count", description="How much recent versions to adapt in multi versions mode", default=1, required=True)

    def on_execute(self):
        yt_token = self.Parameters.yt_token_secret.value()

        from . import bigb_bstr_adapter

        bigb_bstr_adapter.adapter(
            yt_cluster=self.Parameters.yt_cluster,
            yt_token=yt_token,
            bigb_prefix=self.Parameters.yt_bigb_path,
            bstr_prefix=self.Parameters.yt_bstr_path,
            versions_count=self.Parameters.versions_count,
            multi_versions_mode=self.Parameters.multi_versions_mode,
        )
