import argparse

import yandex.type_info.typing as ti
import yt.wrapper as yt


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--proxy', required=True)
    parser.add_argument('--token', required=True)
    parser.add_argument('--replicated-path', required=True)
    parser.add_argument('--replica-path', required=False)
    args = parser.parse_args()

    if args.replica_path is None:
        args.replica_path = args.replicated_path

    yt_markov = yt.YtClient(proxy='markov', token=args.token)
    yt_replica = yt.YtClient(proxy=args.proxy, token=args.token)

    schema = yt.schema.TableSchema(strict=True, unique_keys=True) \
        .add_column('StartTime', ti.Int64, sort_order="ascending") \
        .add_column('OrderID', ti.Int64, sort_order="ascending") \
        .add_column('GroupOrderID', ti.Int64) \
        .add_column('State', ti.String) \
        .add_column('Cost', ti.Int64) \
        .add_column('CostCur', ti.Int64) \
        .add_column('LastGroupMoneyLeft', ti.Int64) \
        .add_column('LastGroupMoneyLeftCur', ti.Int64)

    yt_markov.create('replicated_table', args.replicated_path, attributes={
        'dynamic': True,
        'enable_dynamic_store_read': True,
        'schema': schema,
    })

    replica_id = yt_markov.create('table_replica', attributes={
        'table_path': args.replicated_path,
        'cluster_name': args.proxy,
        'replica_path': args.replica_path,
    })

    yt_replica.create('table', args.replica_path, attributes={
        'dynamic': True,
        'enable_dynamic_store_read': True,
        'schema': schema,
        'upstream_replica_id': replica_id,
    })

    yt_markov.mount_table(args.replicated_path)
    yt_replica.mount_table(args.replica_path)
