from sandbox.sdk2 import Resource, parameters
from sandbox.common.types.resource import State


class YabsCpmMultiplierBinary(Resource):
    """Resource with cpm_multiplier binary
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["yabsstartrek"]


class YabsCpmMultiplier2Binary(Resource):
    """Resource with new cpm_multiplier2 binary
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["yabsstartrek"]


class YabsCpmMultiplierConfig(Resource):
    """Resource with cpm_multiplier config
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["danilgrig", "mirage", "freakalert", "vladikabr"]


class YabsCpmMultiplierYtBackup(Resource):
    """Resource with cpm_multiplier input backup
    """
    __default_attribute__ = parameters.String

    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["YANDEX_MONETIZE_BANNER"]


class YabsCpmMultiplierTestResults(Resource):
    """Resource with cpm_multiplier b2b comparison results
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["YANDEX_MONETIZE_BANNER"]


def get_last_resource(res_type):
    return Resource.find(resource_type=res_type,
                         state=State.READY,
                         attrs={'released': 'stable'}).order(-Resource.id).first()
