# -*- coding: utf-8 -*-

YQL_QUERY = """
            /*
            Скрипт для сбора площадок с плохим трафиком с т.з. рекламодателей
            текущие особенности/недостатки:
            - сбор по JoinedEFH
            - не учитывается IsGoodConversion
            - ограничение по откруткам снизу считается по не-itp трафику и только на заказах со счётчиком или с yclid
            - статистика собирается только по cpc продуктам
            - коэффициент качества рассчитывается как lclicks / clicks
            */
            pragma yt.ExpirationInterval = '{expiration_interval}';

            $current_day = '{current_day}';
            $datetime_parse = DateTime::Parse('%Y-%m-%d');
            $current_day_unixtime = DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::Update($datetime_parse($current_day), 'Europe/Moscow' as Timezone)));
            $start_hour_format = DateTime::Format('%Y-%m-%dT00:00:00');
            $end_hour_format = DateTime::Format('%Y-%m-%dT23:00:00');
            $start_hour = $start_hour_format(AddTimezone(DateTime::FromSeconds($current_day_unixtime), 'Europe/Moscow'));
            $end_hour = $end_hour_format(AddTimezone(DateTime::FromSeconds($current_day_unixtime), 'Europe/Moscow'));
            $exp = '{experiment}'; -- эксперимент, по которому будем замерять качество трафика
            $logs = 'home/bs/logs/JoinedEFH/1h'; -- директория исходного лога
            $page = 'home/yabs/dict/Page'; -- справочник Page
            $partner_page = 'home/yabs/dict/PartnerPage'; -- справочник PartnerPage для получения Login
            $pageimp_ext = '//home/yabs/dict/PageImpExternal'; --справочник для получения свойств imp
            $pageimp = '//home/yabs/dict/PageImp'; --справочник для получения свойств imp
            $pageimp_art = '//home/yabs/dict/PageImpArtmon'; --справочник для получения свойств imp

            $orders_with_metrika = -- выбираем заказы, у которых есть счётчик
            (
            SELECT
                OrderID,
                true as has_counter
            from
                `home/direct/db/campaigns`
            where
                metrika_counters is not null
            );
            $orders_with_yclid = -- выбираем заказы, у которых есть опция yclid
            (
            SELECT
                OrderID,
                true as has_yclid
            from
                `//home/yabs/dict/CaesarOrderInfo`
            where
                OptionsYclid == true
            );
            $page_order_select = -- собираем статистику по pageid и orderid
            (
            SELECT
                pageid,
                orderid,
                impid,
                pagedomainmd5,
                is_ssp,

                count_if(CounterType == 1 and FraudBits = 0) as shows,
                count_if(CounterType == 2 and FraudBits = 0) as clicks,

                count_if(CounterType == 2 and HasCounter == 1 and FraudBits = 0) as vclicks, -- нужно исправить на VisitTrafficSource_ClickIsGoodConversion
                count_if(CounterType == 2 and HasCounter == 1 and LClick = 1 and FraudBits = 0) as lclicks, -- и тут

                NANVL(30.0 * sum_if(EventCost, FraudBits = 0) / 1000 / 1000 / 1.18, 0.0) as cost_rub -- руб. без НДС
            from
                range($logs, $start_hour, $end_hour)
            WHERE
                PlaceID == 542 -- специально смотрим только на cpc продукты
                and ListIndexOf(String::SplitToList(ActiveTestIds, ':;', false), $exp) is not null -- оставляем только экспериментальные данные
                and 'itp' not in String::SplitToList(Options, ',') -- не хотим смотреть на itp-трафике
                and 'flat-page' in String::SplitToList(Options, ',') -- только контекстная сеть
                and ProductType not like '%video%' -- не хотим брать в расчет видеорекламу на которую не можем влиять
            group by
                PageID as pageid,
                OrderID as orderid,
                ImpID as impid,
                PageDomainMD5 as pagedomainmd5,
                'is-ssp' in String::SplitToList(ImpressionOptions, ',') as is_ssp
            );
            insert into `{prefix}/{profile}/raw-data/{current_day}`
            select
                pageid,
                impid,
                pagedomainmd5,
                login,
                is_ssp,
                name,
                block_caption,
                block_model,
                is_turbo,
                is_native_widget,

                nanvl(100.0 * sum(lclicks) / sum(clicks), 0.0) as quality_coef,
                sum(shows) as shows,
                sum(clicks) as clicks,
                sum(vclicks) as vclicks,
                sum(lclicks) as lclicks,
                sum(cost_rub) as cost_rub,
            from
                $page_order_select as pos
            inner join
                $page as p
            on
                pos.pageid == p.PageID
            inner join
                $partner_page as pp
            on
                pos.pageid == pp.PageID
            inner join
                $pageimp_ext as pimpe
            on
                pos.pageid == pimpe.PageID and pos.impid = pimpe.ImpID
            inner join
                $pageimp as pimp
            on
                pos.pageid == pimp.PageID and pos.impid = pimp.ImpID
            inner join
                $pageimp_art as pimpa
            on
                pos.pageid = pimpa.PageID and pos.impid = pimpa.ImpID
            left join
                $orders_with_metrika as owm
            on
                pos.orderid == owm.OrderID
            left join
                $orders_with_yclid as owy
            on
                pos.orderid == owy.OrderID
            where
                (owm.has_counter -- у заказа должен быть либо счётчик
                or owy.has_yclid) -- либо опция yclid в OrderInfo
            group by
                pos.pageid as pageid,
                pos.impid as impid,
                if(pos.is_ssp, pos.pagedomainmd5, 0) as pagedomainmd5,
                pp.Login as login,
                pos.is_ssp as is_ssp,
                p.Name as name,
                pimpe.BlockCaption as block_caption,
                pimpe.BlockModel as block_model,
                (pimp.OptionsTurbo or pimp.OptionsTurboDesktop) as is_turbo,
                (pimpa.InAppType == "native") as is_native_widget
            order by
                pageid,
                impid,
                pagedomainmd5;

            insert into `{prefix}/{profile}/last_date` with truncate
            select
            '{current_day}' as last_date
"""
