from sandbox.sdk2 import parameters

from sandbox.projects.yabs.dropstat.base import BaseDropStatTask


class YabsDropStatPrepareRequest(BaseDropStatTask):
    '''Selects data for dropstat request
    '''
    class Parameters(BaseDropStatTask.Parameters):
        description = 'Prepare dropstat request'
        kill_timeout = 10 * 3600

        with BaseDropStatTask.Parameters.exec_params() as exec_params:
            request_id = parameters.String('RequestID', required=True)

    def on_execute(self):
        from yabs.stat.dropstat2.pylibs.prepare.prepare_request import prepare_request
        from yql.api.v1.client import YqlClient

        yql_client = YqlClient(db=self.Parameters.work_yt_proxy, token=self.yt_token)

        requests = self.find_drop_requests([int(r) for r in self.Parameters.request_id.split(',')])
        prepare_request(self.Parameters.work_yt_proxy, self.yt_token, self.yt_client, yql_client, requests, self.work_dir + '/prepare', self.work_dir + '/prepare_tmp')
