import logging
from sandbox.sandboxsdk import environments
from sandbox import sdk2


class YabsDSPTranslationClientID(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        yql_token_owner = sdk2.parameters.String("YQL Token Owner Name", default="robot-yabs-google", required=True)
        yql_token_vault_name = sdk2.parameters.String("YQL Token vault name", default="robot_google_yql_token", required=True)
        table_name = sdk2.parameters.String("Translation table", default="//home/yabs/dsp/dspid_to_clientid_translation", required=True)
        dspid = sdk2.parameters.Integer("DSPID", required=True)
        clientid = sdk2.parameters.Integer("ClientID", required=True)

    class Requirements(sdk2.Task.Requirements):
        environments = [environments.PipEnvironment('yql', version='1.2.91'), environments.PipEnvironment('yandex-yt')]

    def GetRequest(self, cluster):
        return '''
            INSERT INTO `{table_dspid_to_clientid_translation}` (DSPID, ClientID)
            SELECT {dspid}, {clientid};
        '''.format(
            table_dspid_to_clientid_translation=self.Parameters.table_name,
            dspid=self.Parameters.dspid,
            clientid=self.Parameters.clientid
        )

    def on_execute(self):
        self.yql_token = sdk2.task.Vault.data(self.Parameters.yql_token_owner, self.Parameters.yql_token_vault_name)

        logging.info("Started")

        for cluster in ['hahn', 'arnold']:
            request = self.GetRequest(cluster)
            logging.info("Prepared request " + request)

            from yql.api.v1.client import YqlClient
            client = YqlClient(db=cluster, token=self.yql_token)
            query = client.query(request, syntax_version=1)
            query.run()
            query.wait_progress()

            if not query.is_success:
                raise Exception('\n'.join([str(err) for err in query.errors]))

            logging.info("Done on cluster `{cluster}`".format(cluster=cluster))

        logging.info("Done")
