#!/usr/bin/env python
# -*-coding: utf-8 -*-
# vim: sw=4 ts=4 expandtab ai

from sandbox import sdk2
from sandbox.projects.yabs.base_bin_task import BaseBinTask


class YabsDutyCalendarUpdater(BaseBinTask):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        disk_space = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    """ YABS_DUTY_CALENDAR_UPDATER """
    class Parameters(BaseBinTask.Parameters):
        with BaseBinTask.Parameters.version_and_task_resource() as version_and_task_resource:
            resource_attrs = sdk2.parameters.Dict('Filter resource by', default={'name': 'YabsDutyCalendarUpdater'})

        # calendar parameters
        with sdk2.parameters.Group('Calendar') as calendar_params:
            calendar_uid = sdk2.parameters.Integer("UID", required=True)
            calendar_tz = sdk2.parameters.String("Time zone", default="Europe/Moscow", required=True)
            calendar_tvm_client_id = sdk2.parameters.Integer("TVM client id", required=True)
            calendar_tvm_secret = sdk2.parameters.YavSecret("TVM secret", description="YAV secret ID, key client_secret", required=True)
            calendar_tvm_service_id = sdk2.parameters.Integer("TVM service id (calendar)", required=True)

        # wiki parameters
        with sdk2.parameters.Group('Duty wiki') as wiki_params:
            oauth_token_secret = sdk2.parameters.YavSecret("Token", description="YAV secret ID, key oauth_token", required=True)
            wiki_url = sdk2.parameters.String("URL", required=True)
            wiki_ts_field = sdk2.parameters.String("Timestamp field", default="Week", required=True)
            wiki_ts_format = sdk2.parameters.String("Timestamp format", default="%Y-%m-%d", required=True)
            wiki_old_row_field = sdk2.parameters.String("Old row flag field", default=u"История", required=True)

        # duty parameters
        with sdk2.parameters.Group('Duty specific parameters') as duty_params:
            limit_days = sdk2.parameters.Integer("Limit days", default=14, required=True)
            duty_params = sdk2.parameters.String("Array of settings", description="JSON", multiline=True, required=True)

    def on_execute(self):
        tvm_secret = self.Parameters.calendar_tvm_secret.data()["client_secret"]
        oauth_token = self.Parameters.oauth_token_secret.data()["oauth_token"]
        abc_oauth_token = self.Parameters.oauth_token_secret.data()["abc_oauth_token"]

        from . import duty_calendar

        calendar = duty_calendar.Calendar(
            uid=self.Parameters.calendar_uid,
            tz=self.Parameters.calendar_tz,
            tvm_client_id=self.Parameters.calendar_tvm_client_id,
            tvm_secret=tvm_secret,
            tvm_service_id=self.Parameters.calendar_tvm_service_id,
            oauth_token=oauth_token,
        )

        wiki = duty_calendar.DutyWiki(
            oauth_token=oauth_token,
            url=self.Parameters.wiki_url,
            ts_field=self.Parameters.wiki_ts_field,
            ts_format=self.Parameters.wiki_ts_format,
            old_row_field=self.Parameters.wiki_old_row_field,
        )

        import json
        duty_params_list = json.loads(self.Parameters.duty_params)

        for params in duty_params_list:
            duty = duty_calendar.DutyCalendar(
                calendar=calendar,
                duty_change_layer_id=params["duty_change_layer_id"],
                duty_event_layer_id=params["duty_event_layer_id"],
                event_tag=params["duty_event_tag"],

                wiki=wiki,
                wiki_duty_fields=params["wiki_duty_fields"],

                limit_days=self.Parameters.limit_days,
            )

            duty.update_events()

            if "abc_duty" in params:
                abc_duty_schedule_first = duty_calendar.AbcDutySchedule(
                    params["abc_duty"]["service_slug"],
                    params["abc_duty"]["schedule_slug_first"],
                    wiki=wiki,
                    wiki_duty_fields=params["wiki_duty_fields"],
                    abc_oauth_token=abc_oauth_token
                )

                abc_duty_schedule_first.upload_history('first')

                if "schedule_slug_second" in params["abc_duty"]:
                    abc_duty_schedule_second = duty_calendar.AbcDutySchedule(
                        params["abc_duty"]["service_slug"],
                        params["abc_duty"]["schedule_slug_second"],
                        wiki=wiki,
                        wiki_duty_fields=params["wiki_duty_fields"],
                        abc_oauth_token=abc_oauth_token
                    )

                abc_duty_schedule_second.upload_history('second')
