#!/usr/bin/env python
# -*-coding: utf-8 -*-
# vim: sw=4 ts=4 expandtab ai

import time
from datetime import datetime

from sandbox import sdk2
from sandbox.projects.yabs.base_bin_task import BaseBinTask


class YabsDutyMessagesSender(BaseBinTask):
    """ YABS_DUTY_MESSAGES_SENDER """

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(BaseBinTask.Parameters):
        kill_timeout = 10 * 60

        with BaseBinTask.Parameters.version_and_task_resource() as version_and_task_resource:
            resource_attrs = sdk2.parameters.Dict('Filter resource by', default={'name': 'YabsDutyMessagesSender'})

        # abc parameters
        with sdk2.parameters.Group('ABC') as abc_params:
            abc_token_secret = sdk2.parameters.YavSecret("Token", description="YAV secret ID, key abc_oauth_token", required=True)
            abc_duty_service = sdk2.parameters.String("Duty service slug", required=True)
            abc_duty_schedule_first = sdk2.parameters.String("First duty schedule slug", required=True)
            abc_duty_schedule_second = sdk2.parameters.String("Second duty schedule slug", required=False)

            abc_supbs_service = sdk2.parameters.String("SUPBS service slug", required=False)
            abc_supbs_engine1_schedule = sdk2.parameters.String("SUPBS Engine-1 schedule slug", required=False)

            abc_qo_service = sdk2.parameters.String("Quality Officer service slug", required=False)
            abc_qo_schedule = sdk2.parameters.String("Quality Officer schedule slug", required=False)

        # telegram parameters
        with sdk2.parameters.Group('Telegram') as telegram_params:
            telegram_token_secret = sdk2.parameters.YavSecret("Token", description="YAV secret ID, key telegram_token", required=True)
            telegram_chat_id = sdk2.parameters.Integer("Chat id", required=True)

        # yt parameters
        with sdk2.parameters.Group('YT') as yt_params:
            yt_cluster = sdk2.parameters.String("Cluster", default="locke", required=True)
            yt_token_secret = sdk2.parameters.YavSecret("Token", description="YAV secret ID, key yt_token", required=True)
            yt_path = sdk2.parameters.String("Path", description="for last pinned message id", required=True)

        # juggler parameters
        with sdk2.parameters.Group('Juggler') as juggler_params:
            juggler_namespaces = sdk2.parameters.List("Juggler namespaces", description="List of juggler namespaces for filter", required=False)
            juggler_tags = sdk2.parameters.List("Juggler tag", description="Juggler tag for filter", default=["call_needed"])

        # other parameters
        with sdk2.parameters.Group('Other') as other_params:
            html_message = sdk2.parameters.String("HTML message", description="Optional HTML message (for example with zoom link), sent last", required=False)

    def on_execute(self):
        abc_token = self.Parameters.abc_token_secret.data()["abc_oauth_token"]
        telegram_token = self.Parameters.telegram_token_secret.data()["telegram_token"]
        yt_token = self.Parameters.yt_token_secret.data()["yt_token"]

        from . import duty_messages

        # workaround for ugly sandbox scheduling
        now = datetime.now()
        time_to_sleep_15 = (now.replace(hour=15, minute=0, second=0) - now).total_seconds()
        time_to_sleep_16 = (now.replace(hour=16, minute=0, second=0) - now).total_seconds()
        if 600 > time_to_sleep_15 > 0:
            time.sleep(time_to_sleep_15)
        elif 600 > time_to_sleep_16 > 0:
            time.sleep(time_to_sleep_16)

        if self.Parameters.juggler_namespaces:
            duty_messages.send_report_message(
                abc_token,
                telegram_token,
                self.Parameters.juggler_namespaces,
                self.Parameters.juggler_tags,
                self.Parameters.abc_duty_service,
                self.Parameters.abc_duty_schedule_first,
                self.Parameters.telegram_chat_id
            )

        duty_messages.send_duties_message(
            abc_token,
            telegram_token,
            self.Parameters.yt_cluster,
            yt_token,
            self.Parameters.yt_path,
            self.Parameters.abc_duty_service,
            self.Parameters.abc_duty_schedule_first,
            self.Parameters.abc_duty_schedule_second,
            self.Parameters.abc_supbs_service,
            self.Parameters.abc_supbs_engine1_schedule,
            self.Parameters.abc_qo_service,
            self.Parameters.abc_qo_schedule,
            self.Parameters.telegram_chat_id
        )

        if self.Parameters.html_message:
            duty_messages.send_html_message(
                telegram_token,
                self.Parameters.telegram_chat_id,
                self.Parameters.html_message
            )
