from typing import Dict

from yabs.server.proto.keywords import keywords_schema_pb2

DESCRIPTORS_VALUES = (
    (keywords_schema_pb2.EDataGroup.DESCRIPTOR.values_by_number.values(), "DataGroup", "DataGroup", 1, 27),
    (keywords_schema_pb2.EDataOption.DESCRIPTOR.values_by_number.values(), "Options", "DataOption", 0, 9),
    (keywords_schema_pb2.ELocation.DESCRIPTOR.values_by_number.values(), "LocationV2", "Location", 0, 6),
)


def process_message_KDT(message, yt_row: Dict) -> bool:
    ret = False
    for enum_values, yt_column_name, field_name, enum_initial_index, last_column_bit_shift in DESCRIPTORS_VALUES:
        enum_int_to_name_list = [descriptor.GetOptions().ListFields()[0][1] for descriptor in enum_values]
        enabled_enum_flags_indices = getattr(message, field_name, [])
        enabled_data_group_names = {enum_int_to_name_list[index - enum_initial_index] for index
                                    in enabled_enum_flags_indices}
        enum_bit_mask = 0
        for bit_shift, enum_value in enumerate(enum_int_to_name_list):
            if bit_shift <= last_column_bit_shift:  # Some columns were not created
                yt_row[enum_value] = enum_value in enabled_data_group_names
            enum_bit_mask |= (1 << bit_shift) * bool(yt_row[enum_value])
        ret |= bool(enum_bit_mask)
        yt_row[yt_column_name] = enum_bit_mask

    value_type_index = message.ValueType
    value_type_descriptor = keywords_schema_pb2.EValueType.DESCRIPTOR.values_by_number.values()[value_type_index]
    value_type = value_type_descriptor.GetOptions().ListFields()[0][1]
    yt_row["ValueType"] = value_type
    yt_row["ValueTypeAsInt"] = value_type_index
    return ret
