from typing import Dict

from yabs.server.proto.keywords import keywords_schema_pb2

DESCRIPTORS_VALUES = (
    (keywords_schema_pb2.EKeywordOption.DESCRIPTOR.values_by_number.values(), "Options", "Option", 0),
)


def process_message_KT(message, yt_row: Dict) -> bool:
    ret = False
    for enum_values, yt_column_name, field_name, enum_initial_index in DESCRIPTORS_VALUES:
        enum_int_to_name_list = [descriptor.GetOptions().ListFields()[0][1] for descriptor in enum_values]
        enabled_enum_flags_indices = getattr(message, field_name, [])
        enabled_data_group_names = {enum_int_to_name_list[index - enum_initial_index] for
                                    index in enabled_enum_flags_indices}
        enum_bit_mask = 0
        for bit_shift, enum_value in enumerate(enum_int_to_name_list):
            option_bool_value = enum_value in enabled_data_group_names
            if bit_shift <= 12:  # Some columns were not created
                yt_row[enum_value] = option_bool_value
            enum_bit_mask |= (1 << bit_shift) * option_bool_value
        ret |= bool(enum_bit_mask)
        yt_row[yt_column_name] = enum_bit_mask

    type_index = message.Type
    type_descriptor = keywords_schema_pb2.EKeywordType.DESCRIPTOR.values_by_number.values()[type_index - 1]
    type_kw = type_descriptor.GetOptions().ListFields()[0][1]
    yt_row["Type"] = type_kw
    yt_row["TypeAsInt"] = message.Type
    return ret
