# This module was not supposed to reach prod, but it did, so sorry for code quality
import yt.wrapper


def print_key_column_rows_difference(prod_dict, new_dict, print_fn):
    print_fn("Keys difference:")
    deleted_keys = prod_dict.keys() - new_dict.keys()
    print_fn(f"- {deleted_keys}" if deleted_keys else "No keys deleted")
    added_keys = new_dict.keys() - prod_dict.keys()
    print_fn(f"+ {added_keys}" if added_keys else "No keys added")


def print_changed_cells(prod_dict, new_dict, i, print_fn, key_difference):
    print_fn(f"id={i} differences:")
    print_fn("- " + str({k: prod_dict[i][k] for k in key_difference}))
    print_fn("+ " + str({k: new_dict[i][k] for k in key_difference}))


def print_diff(print_fn, new_Keyword, new_KeywordType, new_KeywordDataType):
    print_fn("============Keyword==============")
    prod_Keyword = list(yt.wrapper.read_table("//home/yabs/dict/Keyword"))

    prod_ids = {r["KeywordID"] for r in prod_Keyword}
    new_ids = {r["KeywordID"] for r in new_Keyword}

    id_intersect = prod_ids.intersection(new_ids)
    print_fn(f"prod_len={len(prod_Keyword)}, new_len={len(new_Keyword)}, intersection_len={len(id_intersect)}")

    prod_dict = {r["KeywordID"]: r for r in prod_Keyword}
    new_dict = {r["KeywordID"]: r for r in new_Keyword}

    print_key_column_rows_difference(prod_dict, new_dict, print_fn)

    for i in id_intersect:
        key_difference = [k for k in prod_dict[i] if prod_dict[i][k] != new_dict[i][k]]
        if not key_difference:
            continue
        print_changed_cells(prod_dict, new_dict, i, print_fn, key_difference)

    print_fn("============KeywordDataType==============")
    prod_KeywordDataType = list(yt.wrapper.read_table("//home/yabs/dict/KeywordDataType"))

    prod_ids = {r["KeywordID"] for r in prod_KeywordDataType}
    new_ids = {r["KeywordID"] for r in new_KeywordDataType}

    id_intersect = prod_ids.intersection(new_ids)
    print_fn(f"prod_len={len(prod_KeywordDataType)}, new_len={len(new_KeywordDataType)}, intersection_len={len(id_intersect)}")

    prod_dict = {r["KeywordID"]: r for r in prod_KeywordDataType}
    new_dict = {r["KeywordID"]: r for r in new_KeywordDataType}

    print_key_column_rows_difference(prod_dict, new_dict, print_fn)

    for i in id_intersect:
        key_difference = [
            k for k in prod_dict[i] if
            not (k.startswith("Location") and not k.startswith("LocationV2")) and  # Ignore location v1
            not (prod_dict[i][k] is None and new_dict[i][k] is False) and  # null == false
            prod_dict[i][k] != new_dict[i][k]
        ]
        if not key_difference:
            continue
        print_changed_cells(prod_dict, new_dict, i, print_fn, key_difference)

    print_fn("============KeywordType==============")
    prod_KeywordType = list(yt.wrapper.read_table("//home/yabs/dict/KeywordType"))

    prod_ids = {(r["KeywordID"], r["Data"], r["Type"]) for r in prod_KeywordType}
    new_ids = {(r["KeywordID"], r["Data"], r["Type"]) for r in new_KeywordType}

    id_intersect = prod_ids.intersection(new_ids)
    print_fn(f"prod_len={len(prod_KeywordType)}, new_len={len(new_KeywordType)}, intersection_len={len(id_intersect)}")

    prod_dict = {(r["KeywordID"], r["Data"], r["Type"]): r for r in prod_KeywordType}
    new_dict = {(r["KeywordID"], r["Data"], r["Type"]): r for r in new_KeywordType}
    print_key_column_rows_difference(prod_dict, new_dict, print_fn)
    for i in id_intersect:
        key_difference = [
            k for k in prod_dict[i] if
            prod_dict[i][k] != new_dict[i][k] and
            not (prod_dict[i][k] is None and not new_dict[i][k])  # null == false
        ]
        if not key_difference:
            continue
        print_changed_cells(prod_dict, new_dict, i, print_fn, key_difference)
