import re
from collections import defaultdict
from typing import Dict, List

from yabs.server.proto.keywords import keywords_schema_pb2, keywords_data_pb2

KW_NEEDED_ROWS = [{'YTHash': 1727372683225193540, 'KeywordID': 377, 'Type': 0, 'Field': '', 'Description': 'Ecom-Офферы, с которыми взаимодействовал пользователь BSDEV-38237'}, {'YTHash': 3950977145108996191, 'KeywordID': 235, 'Type': 0, 'Field': 'visit-goal', 'Description': 'Таргетинг на цели визитов Метрики'}, {'YTHash': 7249397837041606367, 'KeywordID': 458, 'Type': 0, 'Field': '', 'Description': 'Баннеры директа от бесфразных таргетингов BSSERVER-104'}, {'YTHash': 8033566399407138620, 'KeywordID': 62, 'Type': 2, 'Field': '', 'Description': 'Текст поискового запроса'}, {'YTHash': 9282121634347092009, 'KeywordID': 1005, 'Type': 0, 'Field': '', 'Description': 'Регулярные регионы. BIGB-1056'}, {'YTHash': 16256808583374413389, 'KeywordID': 730, 'Type': 0, 'Field': '', 'Description': 'Идентификаторы пользователя по indevice склейке'}, {'YTHash': 18231768630727147181, 'KeywordID': 328, 'Type': 0, 'Field': '', 'Description': 'Поведенческие счётчики по различным ключам'}]  # noqa
KW_DT_NEEDED_ROWS = [{'YTHash': 1727372683225193540, 'KeywordID': 377, 'BlindKeywordID': 0, 'DataGroup': 1, 'DataGroupAdfox': False, 'DataGroupAdfoxWide': False, 'DataGroupAfisha': False, 'DataGroupAll': True, 'DataGroupAtom': False, 'DataGroupAuth': False, 'DataGroupAwaps': False, 'DataGroupBsoutdoor': False, 'DataGroupClid': False, 'DataGroupCollections': False, 'DataGroupDomain': False, 'DataGroupJavareport': False, 'DataGroupKinopoisk': False, 'DataGroupLaas': False, 'DataGroupMarketapi': False, 'DataGroupMarketreport': False, 'DataGroupMoney': False, 'DataGroupMoney2': False, 'DataGroupMorda': False, 'DataGroupMusic': False, 'DataGroupPeopleSearch': False, 'DataGroupPythia': False, 'DataGroupReferer': False, 'DataGroupServerCount': False, 'DataGroupServerMorda': False, 'DataGroupSubdomain': False, 'DataGroupSwitch': False, 'DataGroupVideo': False, 'ExpireDays': 30, 'Location': None, 'LocationBehUQC': None, 'LocationDmpPart': None, 'LocationHubPart': None, 'LocationInstantRFStorage': None, 'LocationQueryPart': None, 'LocationUVFStorage': None, 'LocationUserStorage': None, 'LocationV2': 1, 'LocationV2CookiesTable': False, 'LocationV2IdentificationService': False, 'LocationV2ProfilesTable': True, 'LocationV2SearchPersTable': False, 'LocationVDRFStorage': None, 'LocationValue': None, 'LocationVirtual': None, 'MaxRecordCount': 200, 'Options': 35, 'OptionsBase64': False, 'OptionsBigb': True, 'OptionsBts': True, 'OptionsFairGlue': False, 'OptionsGlueIndeviceOnly': False, 'OptionsGlueWithCryptaIdV2Only': False, 'OptionsHub': False, 'OptionsMultivalue': False, 'OptionsQueryDirty': False, 'OptionsTranslate': True, 'ValueType': 'string', 'ValueTypeAsInt': 6, 'LocationV2LTSearchProfileTable': False, 'LocationV2MarketDJ': False, 'LocationV2LTAdvProfileTable': False}, {'YTHash': 3950977145108996191, 'KeywordID': 235, 'BlindKeywordID': 0, 'DataGroup': 6291521, 'DataGroupAdfox': False, 'DataGroupAdfoxWide': True, 'DataGroupAfisha': False, 'DataGroupAll': True, 'DataGroupAtom': False, 'DataGroupAuth': False, 'DataGroupAwaps': True, 'DataGroupBsoutdoor': False, 'DataGroupClid': False, 'DataGroupCollections': False, 'DataGroupDomain': False, 'DataGroupJavareport': False, 'DataGroupKinopoisk': False, 'DataGroupLaas': False, 'DataGroupMarketapi': False, 'DataGroupMarketreport': False, 'DataGroupMoney': False, 'DataGroupMoney2': False, 'DataGroupMorda': False, 'DataGroupMusic': False, 'DataGroupPeopleSearch': False, 'DataGroupPythia': False, 'DataGroupReferer': False, 'DataGroupServerCount': False, 'DataGroupServerMorda': True, 'DataGroupSubdomain': False, 'DataGroupSwitch': False, 'DataGroupVideo': False, 'ExpireDays': 540, 'Location': None, 'LocationBehUQC': None, 'LocationDmpPart': None, 'LocationHubPart': None, 'LocationInstantRFStorage': None, 'LocationQueryPart': None, 'LocationUVFStorage': None, 'LocationUserStorage': None, 'LocationV2': 1, 'LocationV2CookiesTable': False, 'LocationV2IdentificationService': False, 'LocationV2ProfilesTable': True, 'LocationV2SearchPersTable': False, 'LocationVDRFStorage': None, 'LocationValue': None, 'LocationVirtual': None, 'MaxRecordCount': 2000, 'Options': 38, 'OptionsBase64': False, 'OptionsBigb': False, 'OptionsBts': True, 'OptionsFairGlue': False, 'OptionsGlueIndeviceOnly': False, 'OptionsGlueWithCryptaIdV2Only': False, 'OptionsHub': False, 'OptionsMultivalue': True, 'OptionsQueryDirty': False, 'OptionsTranslate': True, 'ValueType': 'uint32', 'ValueTypeAsInt': 3, 'LocationV2LTSearchProfileTable': False, 'LocationV2MarketDJ': False, 'LocationV2LTAdvProfileTable': False}, {'YTHash': 7249397837041606367, 'KeywordID': 458, 'BlindKeywordID': 0, 'DataGroup': 1, 'DataGroupAdfox': False, 'DataGroupAdfoxWide': False, 'DataGroupAfisha': False, 'DataGroupAll': True, 'DataGroupAtom': False, 'DataGroupAuth': False, 'DataGroupAwaps': False, 'DataGroupBsoutdoor': False, 'DataGroupClid': False, 'DataGroupCollections': False, 'DataGroupDomain': False, 'DataGroupJavareport': False, 'DataGroupKinopoisk': False, 'DataGroupLaas': False, 'DataGroupMarketapi': False, 'DataGroupMarketreport': False, 'DataGroupMoney': False, 'DataGroupMoney2': False, 'DataGroupMorda': False, 'DataGroupMusic': False, 'DataGroupPeopleSearch': False, 'DataGroupPythia': False, 'DataGroupReferer': False, 'DataGroupServerCount': False, 'DataGroupServerMorda': False, 'DataGroupSubdomain': False, 'DataGroupSwitch': False, 'DataGroupVideo': False, 'ExpireDays': 2, 'Location': None, 'LocationBehUQC': None, 'LocationDmpPart': None, 'LocationHubPart': None, 'LocationInstantRFStorage': None, 'LocationQueryPart': None, 'LocationUVFStorage': None, 'LocationUserStorage': None, 'LocationV2': 1, 'LocationV2CookiesTable': False, 'LocationV2IdentificationService': False, 'LocationV2ProfilesTable': True, 'LocationV2SearchPersTable': False, 'LocationVDRFStorage': None, 'LocationValue': None, 'LocationVirtual': None, 'MaxRecordCount': 0, 'Options': 32, 'OptionsBase64': False, 'OptionsBigb': False, 'OptionsBts': True, 'OptionsFairGlue': False, 'OptionsGlueIndeviceOnly': False, 'OptionsGlueWithCryptaIdV2Only': False, 'OptionsHub': False, 'OptionsMultivalue': False, 'OptionsQueryDirty': False, 'OptionsTranslate': False, 'ValueType': 'string', 'ValueTypeAsInt': 6, 'LocationV2LTSearchProfileTable': False, 'LocationV2MarketDJ': False, 'LocationV2LTAdvProfileTable': False}, {'YTHash': 8033566399407138620, 'KeywordID': 62, 'BlindKeywordID': 0, 'DataGroup': 262145, 'DataGroupAdfox': False, 'DataGroupAdfoxWide': False, 'DataGroupAfisha': False, 'DataGroupAll': True, 'DataGroupAtom': False, 'DataGroupAuth': False, 'DataGroupAwaps': False, 'DataGroupBsoutdoor': False, 'DataGroupClid': False, 'DataGroupCollections': True, 'DataGroupDomain': False, 'DataGroupJavareport': False, 'DataGroupKinopoisk': False, 'DataGroupLaas': False, 'DataGroupMarketapi': False, 'DataGroupMarketreport': False, 'DataGroupMoney': False, 'DataGroupMoney2': False, 'DataGroupMorda': False, 'DataGroupMusic': False, 'DataGroupPeopleSearch': False, 'DataGroupPythia': False, 'DataGroupReferer': False, 'DataGroupServerCount': False, 'DataGroupServerMorda': False, 'DataGroupSubdomain': False, 'DataGroupSwitch': False, 'DataGroupVideo': False, 'ExpireDays': 0, 'Location': None, 'LocationBehUQC': None, 'LocationDmpPart': None, 'LocationHubPart': None, 'LocationInstantRFStorage': None, 'LocationQueryPart': None, 'LocationUVFStorage': None, 'LocationUserStorage': None, 'LocationV2': 1, 'LocationV2CookiesTable': False, 'LocationV2IdentificationService': False, 'LocationV2ProfilesTable': True, 'LocationV2SearchPersTable': False, 'LocationVDRFStorage': None, 'LocationValue': None, 'LocationVirtual': None, 'MaxRecordCount': 0, 'Options': 50, 'OptionsBase64': False, 'OptionsBigb': False, 'OptionsBts': True, 'OptionsFairGlue': False, 'OptionsGlueIndeviceOnly': False, 'OptionsGlueWithCryptaIdV2Only': False, 'OptionsHub': False, 'OptionsMultivalue': False, 'OptionsQueryDirty': True, 'OptionsTranslate': True, 'ValueType': 'string', 'ValueTypeAsInt': 6, 'LocationV2LTSearchProfileTable': False, 'LocationV2MarketDJ': False, 'LocationV2LTAdvProfileTable': False}, {'YTHash': 9282121634347092009, 'KeywordID': 1005, 'BlindKeywordID': 0, 'DataGroup': 1, 'DataGroupAdfox': False, 'DataGroupAdfoxWide': False, 'DataGroupAfisha': False, 'DataGroupAll': True, 'DataGroupAtom': False, 'DataGroupAuth': False, 'DataGroupAwaps': False, 'DataGroupBsoutdoor': False, 'DataGroupClid': False, 'DataGroupCollections': False, 'DataGroupDomain': False, 'DataGroupJavareport': False, 'DataGroupKinopoisk': False, 'DataGroupLaas': False, 'DataGroupMarketapi': False, 'DataGroupMarketreport': False, 'DataGroupMoney': False, 'DataGroupMoney2': False, 'DataGroupMorda': False, 'DataGroupMusic': False, 'DataGroupPeopleSearch': False, 'DataGroupPythia': False, 'DataGroupReferer': False, 'DataGroupServerCount': False, 'DataGroupServerMorda': False, 'DataGroupSubdomain': False, 'DataGroupSwitch': False, 'DataGroupVideo': False, 'ExpireDays': 14, 'Location': None, 'LocationBehUQC': None, 'LocationDmpPart': None, 'LocationHubPart': None, 'LocationInstantRFStorage': None, 'LocationQueryPart': None, 'LocationUVFStorage': None, 'LocationUserStorage': None, 'LocationV2': 1, 'LocationV2CookiesTable': False, 'LocationV2IdentificationService': False, 'LocationV2ProfilesTable': True, 'LocationV2SearchPersTable': False, 'LocationVDRFStorage': None, 'LocationValue': None, 'LocationVirtual': None, 'MaxRecordCount': 0, 'Options': 35, 'OptionsBase64': False, 'OptionsBigb': True, 'OptionsBts': True, 'OptionsFairGlue': False, 'OptionsGlueIndeviceOnly': False, 'OptionsGlueWithCryptaIdV2Only': False, 'OptionsHub': False, 'OptionsMultivalue': False, 'OptionsQueryDirty': False, 'OptionsTranslate': True, 'ValueType': 'string', 'ValueTypeAsInt': 6, 'LocationV2LTSearchProfileTable': False, 'LocationV2MarketDJ': False, 'LocationV2LTAdvProfileTable': False}, {'YTHash': 14751718776374139405, 'KeywordID': 1042, 'BlindKeywordID': 0, 'DataGroup': 6291521, 'DataGroupAdfox': False, 'DataGroupAdfoxWide': True, 'DataGroupAfisha': False, 'DataGroupAll': True, 'DataGroupAtom': False, 'DataGroupAuth': False, 'DataGroupAwaps': True, 'DataGroupBsoutdoor': False, 'DataGroupClid': False, 'DataGroupCollections': False, 'DataGroupDomain': False, 'DataGroupJavareport': False, 'DataGroupKinopoisk': False, 'DataGroupLaas': False, 'DataGroupMarketapi': False, 'DataGroupMarketreport': False, 'DataGroupMoney': False, 'DataGroupMoney2': False, 'DataGroupMorda': False, 'DataGroupMusic': False, 'DataGroupPeopleSearch': False, 'DataGroupPythia': False, 'DataGroupReferer': False, 'DataGroupServerCount': False, 'DataGroupServerMorda': True, 'DataGroupSubdomain': False, 'DataGroupSwitch': False, 'DataGroupVideo': False, 'ExpireDays': 7, 'Location': None, 'LocationBehUQC': None, 'LocationDmpPart': None, 'LocationHubPart': None, 'LocationInstantRFStorage': None, 'LocationQueryPart': None, 'LocationUVFStorage': None, 'LocationUserStorage': None, 'LocationV2': 1, 'LocationV2CookiesTable': False, 'LocationV2IdentificationService': False, 'LocationV2ProfilesTable': True, 'LocationV2SearchPersTable': False, 'LocationVDRFStorage': None, 'LocationValue': None, 'LocationVirtual': None, 'MaxRecordCount': 0, 'Options': 35, 'OptionsBase64': False, 'OptionsBigb': True, 'OptionsBts': True, 'OptionsFairGlue': False, 'OptionsGlueIndeviceOnly': False, 'OptionsGlueWithCryptaIdV2Only': False, 'OptionsHub': False, 'OptionsMultivalue': False, 'OptionsQueryDirty': False, 'OptionsTranslate': True, 'ValueType': 'uint64', 'ValueTypeAsInt': 4, 'LocationV2LTSearchProfileTable': False, 'LocationV2MarketDJ': False, 'LocationV2LTAdvProfileTable': False}, {'YTHash': 16256808583374413389, 'KeywordID': 730, 'BlindKeywordID': 0, 'DataGroup': 2097217, 'DataGroupAdfox': False, 'DataGroupAdfoxWide': False, 'DataGroupAfisha': False, 'DataGroupAll': True, 'DataGroupAtom': False, 'DataGroupAuth': False, 'DataGroupAwaps': True, 'DataGroupBsoutdoor': False, 'DataGroupClid': False, 'DataGroupCollections': False, 'DataGroupDomain': False, 'DataGroupJavareport': False, 'DataGroupKinopoisk': False, 'DataGroupLaas': False, 'DataGroupMarketapi': False, 'DataGroupMarketreport': False, 'DataGroupMoney': False, 'DataGroupMoney2': False, 'DataGroupMorda': False, 'DataGroupMusic': False, 'DataGroupPeopleSearch': False, 'DataGroupPythia': False, 'DataGroupReferer': False, 'DataGroupServerCount': False, 'DataGroupServerMorda': True, 'DataGroupSubdomain': False, 'DataGroupSwitch': False, 'DataGroupVideo': False, 'ExpireDays': 1, 'Location': None, 'LocationBehUQC': None, 'LocationDmpPart': None, 'LocationHubPart': None, 'LocationInstantRFStorage': None, 'LocationQueryPart': None, 'LocationUVFStorage': None, 'LocationUserStorage': None, 'LocationV2': 4, 'LocationV2CookiesTable': False, 'LocationV2IdentificationService': True, 'LocationV2ProfilesTable': False, 'LocationV2SearchPersTable': False, 'LocationVDRFStorage': None, 'LocationValue': None, 'LocationVirtual': None, 'MaxRecordCount': 0, 'Options': 35, 'OptionsBase64': False, 'OptionsBigb': True, 'OptionsBts': True, 'OptionsFairGlue': False, 'OptionsGlueIndeviceOnly': False, 'OptionsGlueWithCryptaIdV2Only': False, 'OptionsHub': False, 'OptionsMultivalue': False, 'OptionsQueryDirty': False, 'OptionsTranslate': True, 'ValueType': 'string', 'ValueTypeAsInt': 6, 'LocationV2LTSearchProfileTable': False, 'LocationV2MarketDJ': False, 'LocationV2LTAdvProfileTable': False}, {'YTHash': 18231768630727147181, 'KeywordID': 328, 'BlindKeywordID': 0, 'DataGroup': 2105345, 'DataGroupAdfox': False, 'DataGroupAdfoxWide': False, 'DataGroupAfisha': False, 'DataGroupAll': True, 'DataGroupAtom': False, 'DataGroupAuth': True, 'DataGroupAwaps': False, 'DataGroupBsoutdoor': False, 'DataGroupClid': False, 'DataGroupCollections': False, 'DataGroupDomain': False, 'DataGroupJavareport': False, 'DataGroupKinopoisk': False, 'DataGroupLaas': False, 'DataGroupMarketapi': False, 'DataGroupMarketreport': False, 'DataGroupMoney': False, 'DataGroupMoney2': False, 'DataGroupMorda': False, 'DataGroupMusic': False, 'DataGroupPeopleSearch': False, 'DataGroupPythia': False, 'DataGroupReferer': False, 'DataGroupServerCount': False, 'DataGroupServerMorda': True, 'DataGroupSubdomain': False, 'DataGroupSwitch': False, 'DataGroupVideo': False, 'ExpireDays': 0, 'Location': None, 'LocationBehUQC': None, 'LocationDmpPart': None, 'LocationHubPart': None, 'LocationInstantRFStorage': None, 'LocationQueryPart': None, 'LocationUVFStorage': None, 'LocationUserStorage': None, 'LocationV2': 1, 'LocationV2CookiesTable': False, 'LocationV2IdentificationService': False, 'LocationV2ProfilesTable': True, 'LocationV2SearchPersTable': False, 'LocationVDRFStorage': None, 'LocationValue': None, 'LocationVirtual': None, 'MaxRecordCount': 0, 'Options': 35, 'OptionsBase64': False, 'OptionsBigb': True, 'OptionsBts': True, 'OptionsFairGlue': False, 'OptionsGlueIndeviceOnly': False, 'OptionsGlueWithCryptaIdV2Only': False, 'OptionsHub': False, 'OptionsMultivalue': False, 'OptionsQueryDirty': False, 'OptionsTranslate': True, 'ValueType': 'string', 'ValueTypeAsInt': 6, 'LocationV2LTSearchProfileTable': False, 'LocationV2MarketDJ': False, 'LocationV2LTAdvProfileTable': False}]  # noqa
DG_ALL_KEYWORD_IDS = {1002, 993, 781, 284, 173, 111, 251, 873, 544, 250, 614, 209, 1035, 725, 910, 291, 198, 377, 421, 183, 1084, 225, 882, 315, 322, 602, 355, 728, 238, 888, 801, 304, 494, 880, 248, 742, 601, 541, 407, 172, 867, 911, 280, 881, 235, 408, 128, 326, 927, 509, 955, 924, 25, 788, 970, 409, 778, 887, 294, 533, 557, 401, 547, 597, 543, 255, 158, 367, 242, 353, 217, 691, 406, 404, 1108, 770, 110, 889, 249, 428, 791, 753, 458, 878, 885, 564, 318, 886, 531, 62, 969, 686, 891, 306, 1053, 63, 914, 1063, 903, 884, 1005, 492, 789, 182, 819, 145, 203, 200, 877, 366, 104, 319, 583, 812, 402, 174, 569, 254, 1037, 405, 545, 968, 895, 281, 214, 723, 176, 829, 292, 892, 1089, 234, 411, 177, 305, 289, 942, 229, 371, 554, 264, 909, 259, 1018, 1042, 296, 253, 546, 1064, 868, 231, 216, 276, 971, 818, 1058, 410, 321, 285, 549, 730, 538, 879, 175, 551, 548, 890, 220, 594, 941, 926, 894, 883, 395, 485, 224, 790, 532, 403, 323, 349, 328, 925, 1088, 390}  # noqa


def make_assertion(condition, fail_message):
    if not condition:
        raise AssertionError(fail_message)


def check_proto_yt_consistency(Keyword, KeywordType, KeywordDataType):
    assert len(Keyword) > 200  # Table is nonempty
    assert len(KeywordType) > 200  # Table is nonempty
    assert len(KeywordDataType) > 200  # Table is nonempty
    keyword_ids = set()
    keyword_ids.update({row["KeywordID"] for row in Keyword})
    keyword_ids.update({row["KeywordID"] for row in KeywordType})
    keyword_ids.update({row["KeywordID"] for row in KeywordDataType})
    assert len(keyword_ids) == len(keywords_data_pb2.EKeyword.values())

    Keyword_rows_by_id = {r["KeywordID"]: r for r in Keyword}
    KeywordDataType_rows_by_id = {r["KeywordID"]: r for r in KeywordDataType}
    KeywordType_rows_by_id = defaultdict(list)
    for row in KeywordType:
        KeywordType_rows_by_id[row["KeywordID"]].append(row)
    kwt_type_descriptors = keywords_schema_pb2.EKeywordType.DESCRIPTOR.values_by_number.items()
    kwt_type_index_by_type = {
        type_descriptor.GetOptions().ListFields()[0][1]: i for i, type_descriptor in kwt_type_descriptors
    }

    for keyword_id, enum_value_descriptor in keywords_data_pb2.EKeyword.DESCRIPTOR.values_by_number.items():
        keyword = enum_value_descriptor.GetOptions().ListFields()[0][1]
        kw_row = Keyword_rows_by_id.get(keyword_id, {})
        kwdt_row = KeywordDataType_rows_by_id.get(keyword_id, {})
        kwt_rows = KeywordType_rows_by_id[keyword_id]

        # Check Keyword
        assert kw_row.get("Field", '') == keyword.Name
        assert kw_row.get("Description", '') == keyword.Description
        assert kw_row.get("Type", 0) == keyword.ObsoleteType

        # Check KeywordDataType
        assert kwdt_row.get("BlindKeywordID", 0) == keyword.BlindKeywordID
        assert kwdt_row.get("ExpireDays", 0) == keyword.ExpireDays
        assert kwdt_row.get("MaxRecordCount", 0) == keyword.MaxRecordCount
        value_type_descriptor = keywords_schema_pb2.EValueType.DESCRIPTOR.values_by_number.values()[keyword.ValueType]
        value_type = value_type_descriptor.GetOptions().ListFields()[0][1]
        assert kwdt_row.get("ValueType", "unknown") == value_type

        dg_count = sum(1 for k in kwdt_row if re.fullmatch(r"DataGroup\w+", k) and kwdt_row[k] is True)
        assert dg_count == len(keyword.DataGroup)
        assert bin(kwdt_row.get("DataGroup", 0)).count("1") == len(keyword.DataGroup)

        do_count = sum(1 for k in kwdt_row if re.fullmatch(r"Options\w+", k) and kwdt_row[k] is True)
        assert do_count == len(keyword.DataOption)
        assert bin(kwdt_row.get("Options", 0)).count("1") == len(keyword.DataOption)

        location_count = sum(1 for k in kwdt_row if re.fullmatch(r"LocationV2\w+", k) and kwdt_row[k] is True)
        assert location_count == len(keyword.Location)
        assert bin(kwdt_row.get("LocationV2", 0)).count("1") == len(keyword.Location)

        # Check KeywordType
        assert len(kwt_rows) == len(keyword.KeywordType)
        kwt_row_tuples = {
            (
                kwt_type_index_by_type[kwt_row.get("Type", "")],
                kwt_row.get("Data", ""),
                bin(kwt_row.get("Options", 0)).count("1"),
                sum(1 for k in kwt_row if re.fullmatch(r"Options\w+", k) and kwt_row[k] is True),
            )
            for kwt_row in kwt_rows
        }
        for kt in keyword.KeywordType:
            assert (
                kt.Type,
                kt.Name,
                len(kt.Option),
                len([index for index in kt.Option if index <= 12]),
            ) in kwt_row_tuples


def verify_snapshot_content(tables: Dict[str, List[Dict]]):
    Keyword = tables["Keyword"]
    KeywordType = tables["KeywordType"]
    KeywordDataType = tables["KeywordDataType"]
    KeywordDataType_rows_by_id = {r["KeywordID"]: r for r in KeywordDataType}
    make_assertion(
        len(Keyword) >= 330,
        f"Table Keyword should contain at least 330 rows but only has f{len(Keyword)}."
    )
    make_assertion(
        (length := len({row["KeywordID"] for row in KeywordDataType})) > 200,
        f"At least 200 keywords should have KeywordDataType rows but only {length} do."
    )
    make_assertion(
        (length := len({row["KeywordID"] for row in KeywordType})) > 1050,
        f"At least 1050 keywords should have KeywordType rows but only {length} do"
    )
    make_assertion(
        len(not_found_rows := [row for row in KW_NEEDED_ROWS if row not in Keyword]) == 0,  # Inefficient O(n^2) but it's ok; shoudn't have more than like 1M comparisons. Can be improved by replacing dicts with (named) tuples but not worth it IMHO # noqa
        f"Important kw changed (in table Keyword), "
        f"make sure this change is needed and change KW_NEEDED_ROWS.\n"
        f"Missing rows: {not_found_rows}"
    )

    make_assertion(
        len(not_found_rows := [row for row in KW_DT_NEEDED_ROWS if row not in KeywordDataType]) == 0,  # ditto
        f"Important kw changed (in table KeywordDataType), "
        f"make sure this change is needed and change KW_DT_NEEDED_ROWS.\n"
        f"Missing rows: {not_found_rows}"
    )
    make_assertion(
        len(not_found_rows := DG_ALL_KEYWORD_IDS - KeywordDataType_rows_by_id.keys()) == 0,
        f"Important keywords with DataGroupAll (DG_ALL_KEYWORD_IDS) must be present in table KeywordDataType,"
        f"but the ones with following keys are missing:\n"
        f"{not_found_rows}"
    )
    make_assertion(
        len(bad_rows := [kw_id for kw_id in DG_ALL_KEYWORD_IDS
                         if not KeywordDataType_rows_by_id[kw_id]["DataGroupAll"]]) == 0,
        f"Some keywords (DG_ALL_KEYWORD_IDS) must have DataGroupAll attribute, but some do not:\n"
        f"{bad_rows}"
    )
    make_assertion(
        len(bad_rows := [row for row in KeywordDataType if
                         (row["OptionsGlueIndeviceOnly"] or row["OptionsGlueWithCryptaIdV2Only"]) and
                         not row["OptionsTranslate"]]) == 0,
        f"OptionsGlueIndeviceOnly and OptionsGlueWithCryptaIdV2Only must implicate OptionsTranslate but that fails "
        f"for rows:\n {bad_rows}"
    )
    check_proto_yt_consistency(Keyword, KeywordType, KeywordDataType)
    return True
