# -*- coding: utf-8 -*-

import tarfile
import sandbox.common.types.client as ctc

from sandbox import sdk2
from sandbox.projects.common.yabs.yabs_global_info_hosts import YabsGlobalInfoHosts


class YabsDownloadGlobalInfoHosts(sdk2.Task):
    class Parameters(sdk2.Parameters):
        resource_type = sdk2.parameters.String(
            "Type of resource to create",
            default="YABS_GLOBAL_INFO_HOSTS",
        )
        path = sdk2.parameters.String(
            "Resource path",
            default="hosts.tgz",
        )

    class Requirements(sdk2.Requirements):
        client_tags = ctc.Tag.LINUX_PRECISE
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        files = YabsGlobalInfoHosts.download()
        result = sdk2.ResourceData(
            sdk2.Resource[self.Parameters.resource_type](
                self,
                "Create global-info resource for {path}".format(path=self.Parameters.path),
                self.Parameters.path,
            )
        ).path
        with tarfile.open(str(result), mode="w:gz") as tar:
            for f in files:
                tar.add(f)
