import jinja2

RAW_TEMPLATE = """
{% for source in sources %}
                            scatter_source_t scatter_{{loop.index}} = scatter_source_t {
                            port = ${{tag}}_port
                            use_connstat = true
                            is_user_sticky = true
{% for endpoint in source.1 %}
                            yp_service_t service_{{loop.index}} = yp_service_t {
                                clusters = { {{source.0}} }
                                endpoint_set = {{endpoint}}
                            }
{% endfor %}
                            yp_services = {
{%- for endpoint in source.1 %}
                                 service_{{loop.index}}
{%- endfor %}
                            }
                            }
{%- endfor %}
                            scatter_sources = {
{% for source in sources %}
                            scatter_{{loop.index}}
{%- endfor %}

                            }
"""


"""
normal (w/o sharding)
tag : {
    ctype : {
        cluster: [
            [endpointset_id_1, endpointset_id_2]
        ]
    }
}
w/ sharding
tag : {
    ctype : {
        cluster: [
            [endpointset_id_1 for shard1, endpointset_id_2 for shard1],
            [endpointset_id_1 for shardN, endpointset_id_2 for shardN]
        ]
    }
}
"""
ENDPOINTS_BY_TAG = {
    'offer_match': {
        'prod': {
            'iva': [['"yabs-offer-match-production-iva-1.offer-match"']],
            'sas': [['"yabs-offer-match-production-sas-1.offer-match"']],
            'vla': [['"yabs-offer-match-production-vla-1.offer-match"']],
            'man': [['"yabs-offer-match-production-man-1.offer-match"']],
        }
    },
    'goalnet': {
        'prod': {
            'iva': [['"yabs-goalnet-production-iva-1.goalnet"', '"goalnet-production-1.deployUnit"']],
            'sas': [['"yabs-goalnet-production-sas-1.goalnet"', '"goalnet-production-1.deployUnit"']],
            'vla': [['"yabs-goalnet-production-vla-1.goalnet"', '"goalnet-production-1.deployUnit"']],
            'man': [['"yabs-goalnet-production-man-1.goalnet"', '"goalnet-production-1.deployUnit"']],
        },
        'prestable': {
            'iva': [['"goalnet-preproduction-1.deployUnit"']],
            'sas': [['"goalnet-preproduction-1.deployUnit"']],
            'vla': [['"goalnet-preproduction-1.deployUnit"']],
            'man': [['"goalnet-preproduction-1.deployUnit"']],
        },
    },
}

ENDPOINTS_BY_TAG_SANDBOX = {
    'offer_match': {
        'prod': {
            'sandbox': [['"offer-match"']],
        }
    },
    'goalnet': {
        'prod': {
            'sandbox': [['"goalnet"']],
        }
    },
}


def calc_endpointset(cluster, endpointsets):
    return [('"{}"'.format(cluster), endpoint) for endpoint in endpointsets.get(cluster)]


def get_scatter_source(tag, tags_dict, dc, ctype='prod'):
    if not tags_dict.get(tag, False):
        return ''
    ctype = ctype if ctype in tags_dict[tag] else 'prod'
    endpoint_sets = calc_endpointset(dc, tags_dict[tag][ctype])
    return scatter_template(tag, endpoint_sets)


def scatter_template(tag, endpoint_sets):
    env = jinja2.Environment()
    template = env.from_string(RAW_TEMPLATE)
    return template.render(sources=endpoint_sets, tag=tag)
