from sandbox import sdk2

from sandbox.projects.common.build.YaPackage import YaPackageResource


class YabsServerInfraResource(sdk2.Resource):
    """ Base class for infra resources with common settings """
    releasable = True
    releasers = ['YABS_SERVER_SANDBOX_TESTS']
    ttl = 365
    auto_backup = True


class YabsServerValidator(YabsServerInfraResource):
    """ Resource with yabs_server_validator """
    pass


class YabsServerValidatorHooks(YabsServerInfraResource):
    """ Resource with yabs_server_validator hooks"""
    pass


class YabsBstr(YabsServerInfraResource):
    """ Resource with yabs_bstr """
    pass


class YabsUnifiedAgentConfiguration(YabsServerInfraResource):
    """ Resource with UA and push-client configuration """
    pass


class YabsJugglerChecksBundle(YabsServerInfraResource):
    """ Resource with juggler checks bundle for YABS frontend """
    pass


class YabsPoormansprofiler(YabsServerInfraResource):
    """ Resource with poormansprofiler """
    pass


class YabsServerL7Balancer(YabsServerInfraResource):
    """Resource with yabs l7 balancer"""
    pass


class YabsTableDefRenamer(YabsServerInfraResource):
    """Renames table_defs to versioned by md5 names"""
    pass


class YabsFrontendStatic(YabsServerInfraResource):
    """Resource with static data needed for YABS frontend instances"""
    pass


class BaseStagesMonitorPackage(sdk2.resource.AbstractResource):
    """Resource with base stages monitor server and static files"""
    releasable = True
    releasers = ['YABS_SERVER_SANDBOX_TESTS']


class BaseStagesMetricsPackage(sdk2.resource.AbstractResource):
    """Resource with base stages metrics server"""
    releasable = True
    releasers = ['YABS_SERVER_SANDBOX_TESTS']


class YabsSolomonController(sdk2.Resource):
    """
        yabs-solomon-controller
    """
    auto_backup = True
    releasable = True
    releasers = ['m-lyubimov', 'robot-testenv', 'robot-srch-releaser', 'robot-yabs-infra', 'YABS_SERVER_SANDBOX_TESTS']
    calc_md5 = True


class YabsPnocsyLayer(YaPackageResource):
    auto_backup = True
    releasable = True
    releasers = ["YABS_SERVER_PNOCSY"]
    ttl = 365
    calc_md5 = True
    share = True


class YabsPnocsyBalancerLayer(YabsPnocsyLayer):
    pass


class YabsPnocsyControllerLayer(YabsPnocsyLayer):
    pass


class YabsPnocsyAgentLayer(YabsPnocsyLayer):
    pass


class YabsPnocsyBinaryLayer(YabsPnocsyLayer):
    pass


class YabsCacheProxyLayer(YaPackageResource):
    auto_backup = True
    releasable = True
    releasers = ["YANDEX_MONETIZE_BANNER_RT"]
    ttl = 365
    calc_md5 = True
    share = True


class YabsCacheProxyCacheProxyBinaryLayer(YabsCacheProxyLayer):
    pass


class YabsCacheProxyCacheProxyConfigLayer(YabsCacheProxyLayer):
    pass


class YabsCacheProxyCaasBinaryLayer(YabsCacheProxyLayer):
    pass


class YabsCacheProxyCaasConfigLayer(YabsCacheProxyLayer):
    pass


class YabsCacheProxyCachedBinaryLayer(YabsCacheProxyLayer):
    pass


class YabsCacheProxyCachedConfigLayer(YabsCacheProxyLayer):
    pass


class YabsRtbCacheLayer(YaPackageResource):
    auto_backup = True
    releasable = True
    releasers = ["YANDEX_MONETIZE_BANNER_RT"]
    ttl = 365
    calc_md5 = True
    share = True


class YabsRtbCacheCaasBinaryLayer(YabsRtbCacheLayer):
    pass


class YabsRtbCacheCaasConfigLayer(YabsRtbCacheLayer):
    pass


class YabsRtbCacheCachedBinaryLayer(YabsRtbCacheLayer):
    pass


class YabsRtbCacheCachedConfigLayer(YabsRtbCacheLayer):
    pass


class YabsBscountLayer(YaPackageResource):
    auto_backup = True
    releasable = True
    releasers = ['BSCOUNT']
    ttl = 365
    calc_md5 = True
    share = True


class YabsBscountBscountBinaryLayer(YabsBscountLayer):
    pass


class YabsBscountBscountConfigLayer(YabsBscountLayer):
    pass


class YabsBscountUnifiedAgentBinaryLayer(YabsBscountLayer):
    pass


class YabsBscountUnifiedAgentConfigLayer(YabsBscountLayer):
    pass


class YabsBscountModelsDataLayer(YabsBscountLayer):
    pass


class YabsBscountGeoDataLayer(YabsBscountLayer):
    pass


class YabsSnitch(YaPackageResource):
    auto_backup = True
    releasable = True
    releasers = ['aybekko97', 'robot-srch-releaser', 'robot-yabs-infra', 'YABS_SERVER_SANDBOX_TESTS']
    calc_md5 = True


class YabsMonitoringsBinary(YaPackageResource):
    """
        yabs-monitorings-binary
    """
    auto_backup = True
    releasable = True
    releasers = ['robot-srch-releaser', 'robot-yabs-infra', 'YABS_SERVER_SANDBOX_TESTS']
    calc_md5 = True


class YabsServerNewRuntime(YaPackageResource):
    """
        yabs/server/libs/new_server
    """
    auto_backup = True
    releasable = True
    releasers = ['robot-srch-releaser', 'robot-yabs-infra', 'YABS_SERVER_SANDBOX_TESTS', 'lshestov']
    calc_md5 = True


class YabsSspSolomonController(sdk2.Resource):
    """
        yabs-ssp-solomon-controller
    """
    auto_backup = True
    releasable = True
    releasers = ['robot-testenv', 'robot-srch-releaser', 'robot-yabs-infra', 'YABS_SERVER_SANDBOX_TESTS']
    calc_md5 = True


class YabsShardmap(sdk2.Resource):
    """
        SANDBOX_SHARDMAP for yabs frontend stat Nannt services
    """
    auto_backup = True
    releasable = True
    releasers = ['nanny-robot', 'robot-yabs-infra', 'YABS_SERVER_SANDBOX_TESTS']
    calc_md5 = True
    ttl = 'inf'
