from sandbox.projects.yabs.qa.multiple_sut_wrapper.sut.adapters.sandbox import MultipleSUTSandboxAdapter
from sandbox.projects.yabs.apphost.sut.adapters.sandbox import ApphostSUTSandboxAdapter
from sandbox.projects.yabs.mobile_ads_sdk.sut.adapters.sandbox import MobileAdsSdkSUTSandboxAdapter
from sandbox.projects.yabs.nanpu.sut.adapters.sandbox import NanpuSUTSandboxAdapter
from sandbox.projects.yabs.mobile_ads_sdk.nanpu_graph_sut.adapters.sandbox.parameters import NanpuGraphSUTParameters


class NanpuGraphSUTSandboxAdapter(MultipleSUTSandboxAdapter):
    sut_name_to_adapter_class = {
        "apphost": ApphostSUTSandboxAdapter,
        "mobile_ads_sdk": MobileAdsSdkSUTSandboxAdapter,
        "nanpu": NanpuSUTSandboxAdapter,
    }

    def __init__(self, parameters, task_instance):
        MultipleSUTSandboxAdapter.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return NanpuGraphSUTParameters
