from sandbox.projects.yabs.apphost.sut.adapters.sandbox.parameters import ApphostSUTParameters
from sandbox.projects.yabs.mobile_ads_sdk.sut.adapters.sandbox.parameters import MobileAdsSdkSUTParameters
from sandbox.projects.yabs.nanpu.sut.adapters.sandbox.parameters import NanpuSUTParameters
from sandbox import sdk2


class NanpuGraphSUTParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Apphost SUT parameters:') as apphost_sut_group:
        apphost = ApphostSUTParameters()

    with sdk2.parameters.Group('Mobile Ads Sdk SUT parameters:') as mobile_ads_sdk_sut_group:
        mobile_ads_sdk = MobileAdsSdkSUTParameters()

    with sdk2.parameters.Group('Nanpu SUT parameters') as nanpu_sut_group:
        nanpu = NanpuSUTParameters()

    port = sdk2.parameters.Integer('Port', required=True)
