from sandbox.projects.yabs.qa.multiple_sut_wrapper.sut.adapters.standalone import MultipleSUTStandaloneAdapter
from sandbox.projects.yabs.apphost.sut.adapters.standalone import ApphostSUTStandaloneAdapter
from sandbox.projects.yabs.mobile_ads_sdk.sut.adapters.standalone import MobileAdsSdkSUTStandaloneAdapter
from sandbox.projects.yabs.nanpu.sut.adapters.standalone import NanpuSUTStandaloneAdapter


class NanpuGraphSUTStandaloneAdapter(MultipleSUTStandaloneAdapter):
    sut_name_to_adapter_class = {
        "apphost": ApphostSUTStandaloneAdapter,
        "mobile_ads_sdk": MobileAdsSdkSUTStandaloneAdapter,
        "nanpu": NanpuSUTStandaloneAdapter,
    }

    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache', work_dir='work_dir', base_dir='base_dir', is_debug=False):
        self.sut_name_to_kwargs = {
            "mobile_ads_sdk": {
                "is_debug": is_debug
            },
        }

        MultipleSUTStandaloneAdapter.__init__(self, parameters, logs_dir, resource_cache_dir, work_dir, base_dir)
