import os

from parameters import MobileAdsSdkSUTParameters
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.yabs.mobile_ads_sdk.sut import MobileAdsSdkSUT
from sandbox.projects.yabs.mobile_ads_sdk.sut.adapters.interface import MobileAdsSdkSUTAdapterInterface


class MobileAdsSdkSUTSandboxAdapter(MobileAdsSdkSUTAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return MobileAdsSdkSUTParameters

    def get_jdk_resource_path(self):
        return self.sync_resource(self.parameters.jdk_resource)

    def get_mobile_ads_sdk_resource_path(self):
        return self.sync_resource(self.parameters.mobile_ads_sdk_resource)

    def get_work_dir(self):
        return os.getcwd()

    def get_core_count(self):
        return self.parameters.core_count

    def get_mobile_ads_sdk_port(self):
        return self.parameters.mobile_ads_sdk_port

    def create_module(self):
        return MobileAdsSdkSUT(self)
