from sandbox import sdk2
from sandbox.projects.pcode.resources import MobileAdsSdkServiceResource
from sandbox.projects.resource_types import JAVA_JDK_ENVIRONMENT


class MobileAdsSdkSUTParameters(sdk2.Task.Parameters):
    core_count = sdk2.parameters.Integer('Core count', default_value=1)
    mobile_ads_sdk_port = sdk2.parameters.Integer('Port for mobile ads sdk', required=True)
    mobile_ads_sdk_resource = sdk2.parameters.Resource('Resource with mobile ads sdk package', resource_type=MobileAdsSdkServiceResource, required=True)
    jdk_resource = sdk2.parameters.Resource('Resource with java jdk environment', resource_type=JAVA_JDK_ENVIRONMENT, required=True)
