import os
import shutil

from sandbox.projects.yabs.qa.adapter_base.standalone import StandaloneAdapterBase
from sandbox.projects.yabs.mobile_ads_sdk.sut import MobileAdsSdkSUT
from sandbox.projects.yabs.mobile_ads_sdk.sut.adapters.interface import MobileAdsSdkSUTAdapterInterface


class MobileAdsSdkSUTStandaloneAdapter(MobileAdsSdkSUTAdapterInterface, StandaloneAdapterBase):
    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache', work_dir='work_dir', base_dir='base_dir', is_debug=False):
        StandaloneAdapterBase.__init__(self, parameters, logs_dir, resource_cache_dir)
        self.work_dir=work_dir
        self.is_debug=is_debug
        if os.path.isdir(work_dir):
            shutil.rmtree(work_dir)
        os.makedirs(work_dir)

    def get_jdk_resource_path(self):
        return self.sync_resource(self.parameters.jdk_resource)

    def get_mobile_ads_sdk_resource_path(self):
        return self.sync_resource(self.parameters.mobile_ads_sdk_resource)

    def get_work_dir(self):
        return self.work_dir

    def get_core_count(self):
        return self.parameters.core_count

    def get_mobile_ads_sdk_port(self):
        return self.parameters.mobile_ads_sdk_port

    def create_module(self):
        return MobileAdsSdkSUT(self)
