from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox import (
    AmmoRequestlogModuleGeneralSandboxAdapter,
)
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.task_factory.simple_shoot_task import factory as simple_shoot_task_factory
from sandbox.projects.yabs.qa.yt_uploader_module.adapters.sandbox import ShootResultsYtUploaderGenericSandboxAdapter
from sandbox.projects.yabs.mobile_ads_sdk.nanpu_graph_sut.adapters.sandbox import NanpuGraphSUTSandboxAdapter
from sandbox.projects.yabs.qa.tasks.BsNanpuSimpleShootTask import BsNanpuResponseDump


class AmmoRequestlogWithRepeatedQueryargsAdapter(AmmoRequestlogModuleGeneralSandboxAdapter):
    def __init__(self, parameters, task_instance):
        AmmoRequestlogModuleGeneralSandboxAdapter.__init__(
            self, parameters, task_instance, allow_repeated_queryargs=True
        )


class NanpuGraphSimpleShootTask(
    simple_shoot_task_factory(
        NanpuGraphSUTSandboxAdapter,
        AmmoRequestlogWithRepeatedQueryargsAdapter,
        DolbiloModuleSandboxAdapter,
        BsNanpuResponseDump,
        'NANPU_GRAPH',
        ShootResultsYtUploaderGenericSandboxAdapter,
    )
):
    class Requirements(sdk2.Task.Requirements):
        privileged = True
        client_tags = ctc.Tag.LINUX_XENIAL & ctc.Tag.INTEL_E5_2660V4 & (ctc.Tag.SAS | ctc.Tag.VLA | ctc.Tag.MAN)
