# coding: utf-8
from sandbox import sdk2
from sandbox import common
import sandbox.common.types.task as ctt

from sandbox.projects.sandbox_ci.sandbox_ci_hermione import SandboxCiHermione
from sandbox.projects.yabs.mocks.resources import BsMocksYaPackage


SANDBOX_CI_SEARCH_INTERFACES_GROUP = 'SANDBOX_CI_SEARCH_INTERFACES'
YABS_DATA_PATCHES_KEY = 'YABS_DATA_PATCHES'
SERP_WEB4_TAG = 'SERP/WEB4'
DEV_TAG = 'DEV'


class BsMocksToHermione(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl(
            'Path to Arcadia svn',
            default_value='arcadia:/arc/trunk/arcadia',
            required=True
        )
        arcadia_patch = sdk2.parameters.String('Apply patch (text diff or rbtorrent)', multiline=True)
        hermione_custom_opts = sdk2.parameters.String('Custom args for Hermione')

    @sdk2.header()
    def header(self):
        if not self.Context.hermione_task_id:
            return 'Testing'

        return sdk2.Task[self.Context.hermione_task_id].header()

    def on_execute(self):
        with self.memoize_stage.create_resource:
            ya_package_task = sdk2.Task['YA_PACKAGE'](
                self,
                owner=SANDBOX_CI_SEARCH_INTERFACES_GROUP,
                description='BS mocks',
                checkout_arcadia_from_url=self.Parameters.checkout_arcadia_from_url,
                arcadia_patch=self.Parameters.arcadia_patch,
                use_aapi_fuse=True,
                use_arc_instead_of_aapi=True,
                aapi_fallback=True,
                package_type='tarball',
                packages='yabs/server/test/ft/collect_mock_data.json',
                resource_type=BsMocksYaPackage.name,
                use_new_format=True,
            ).enqueue()
            self.Context.ya_package_task_id = ya_package_task.id
            raise sdk2.WaitTask([ya_package_task], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)

        with self.memoize_stage.run_hermione:
            task = SandboxCiHermione.find(
                status=ctt.Status.Group.FINISH,
                tags=[SERP_WEB4_TAG, DEV_TAG],
                all_tags=True,
                children=True,
            ).first()

            ya_package_task = sdk2.Task[self.Context.ya_package_task_id]

            if ya_package_task.status not in ctt.Status.Group.SUCCEED:
                raise common.errors.TaskFailure("YA_PACKAGE build failed")

            resource = sdk2.Resource.find(
                BsMocksYaPackage,
                task=ya_package_task,
            ).first()

            parameters = {
                k: v
                for k, v in task.Parameters
                if not getattr(SandboxCiHermione.Parameters, k).__output__
            }
            parameters['owner'] = SANDBOX_CI_SEARCH_INTERFACES_GROUP
            parameters['tags'] = [SERP_WEB4_TAG]
            parameters['description'] = 'trying task {}'.format(task.id)
            parameters['environ'].update({YABS_DATA_PATCHES_KEY: resource.id})
            parameters['report_github_statuses'] = False
            parameters['reuse_task_cache'] = False
            parameters['reuse_subtasks_cache'] = False
            parameters['reuse_artifacts_cache'] = False

            if self.Parameters.hermione_custom_opts:
                parameters['custom_opts'] += ' ' + self.Parameters.hermione_custom_opts

            hermione_task = SandboxCiHermione(self, **parameters).enqueue()
            self.Context.hermione_task_id = hermione_task.id
            raise sdk2.WaitTask([hermione_task], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)

        hermione_task = sdk2.Task[self.Context.hermione_task_id]

        if hermione_task.status not in ctt.Status.Group.SUCCEED:
            raise common.errors.TaskFailure("Hermione tests fail")
