#!/usr/bin/env python
# -*-coding: utf-8 -*-
# vim: sw=4 ts=4 expandtab ai

import json
import logging
import requests

from sandbox import sdk2


class MoneyLossSync(sdk2.Task):
    """ MONEY_LOSS_SYNC """

    class Parameters(sdk2.Task.Parameters):

        st_token_secret = sdk2.parameters.YavSecret("StarTrek API token", required=True)
        warden_token_secret = sdk2.parameters.YavSecret("Warden API token", required=True)
        st_filter = sdk2.parameters.String("StartTrek tickets filter", required=True)

    def on_execute(self):
        st_token = self.Parameters.st_token_secret.data()[self.Parameters.st_token_secret.default_key]
        warden_token = self.Parameters.warden_token_secret.data()[self.Parameters.warden_token_secret.default_key]

        st_api_endpoint = 'https://st-api.yandex-team.ru/v2'

        st = requests.Session()
        st.headers['Content-Type'] = 'application/json'
        st.headers['Authorization'] = 'OAuth {}'.format(st_token)

        st_url = st_api_endpoint+"/issues?query={}".format(self.Parameters.st_filter)

        warden = requests.Session()
        warden.headers['Content-Type'] = 'application/json'
        warden.headers['Authorization'] = 'OAuth {}'.format(warden_token)

        warden_url = "https://warden.z.yandex-team.ru/api/warden.Warden/addMetricValue"

        st_data = st.get(st_url).json()
        for ticket in st_data:
            ticket_key = ticket["key"]
            ticket_money_loss = ticket["dengiVFiskah"]

            warden_data = {
                "incident_key": ticket_key,
                "metric_key": "warden_money_loss",
                "value": ticket_money_loss
            }

            warden_response = warden.post(warden_url, data=json.dumps(warden_data))

            logging.info("warden response is \"{} {}\" for tiket {} with money loss {}".format(
                warden_response.status_code,
                warden_response.text,
                ticket_key,
                ticket_money_loss
            ))
