import logging
import json
from collections import defaultdict

from sandbox.projects.yabs.monitoring.tasks.CollectYtUsageStatistics.lib.sandbox_filters import get_tasks_info, get_task_id_from_operation_spec
from sandbox.projects.yabs.monitoring.tasks.CollectYtUsageStatistics.lib.aggregation import AggregationKey, get_aggr_key


def need_sandbox(aggr_by):
    return any([
        aggr_column in aggr_by
        for aggr_column in AggregationKey.Sandbox.__dict__.values()
    ])


def get_aggregated_operations(operations, aggr_by, sandbox_client=None):
    if need_sandbox(aggr_by):
        task_id_by_operation_id = {
            op["operation_id"]: get_task_id_from_operation_spec(json.loads(op["spec"]), op["operation_id"])
            for op in operations
        }

        task_ids = list(set(filter(None, task_id_by_operation_id.values())))
        logging.info("Requesting %s", task_ids)
        tasks_info = get_tasks_info(task_ids, sandbox_client, aggr_by=aggr_by)
    else:
        tasks_info = {}
        task_id_by_operation_id = {}

    aggregated_operations = defaultdict(list)
    for op in operations:
        aggr_key = get_aggr_key(op, aggr_by, tasks_info, task_id_by_operation_id)
        aggregated_operations[aggr_key].append(op)

    return aggregated_operations
