
REPORT_HTML_TEMPLATE = """
<style>
.table {
    white-space: normal;
}
.table table {
    border-collapse: collapse;
}
.table th {
    padding: 2px 8px;
    text-align: left;
    vertical-align: top;
    background-color: #f2f2f2;
    border: 1px solid #ddd;
}
.table tr {
    padding: 2px 8px;
    text-align: left;
    vertical-align: top;
}
.table td {
    padding: 2px 8px;
    border: 1px solid #ddd;
}
.table pre {
    white-space: pre-wrap;
}
</style>
<div class="table">
Operations from {{ from_time }} to {{ to_time }}
<table>
    <thead>
        <tr>
            {% for column in header -%}
            <th>{{ column }}</th>
            {%- endfor %}
        </tr>
    </thead>
    <tbody>
        {% for row in rows %}
        <tr>
            {% for column in header -%}
            <td>{{ row[column] }}</td>
            {%- endfor %}
        </tr>
        {%- endfor %}
    </tbody>
</table>
</div>
"""


def create_html_report(rows, header, from_time, to_time):
    from jinja2 import Environment

    env = Environment()
    template = env.from_string(REPORT_HTML_TEMPLATE)
    return template.render(rows=rows, header=header, from_time=str(from_time), to_time=str(to_time))
