import logging


class StartrekHelper():

    def __init__(self, useragent, st_token):
        from startrek_client import Startrek
        self.st_client = Startrek(useragent=useragent, token=st_token)

    def create_issue(self, queue, summary, description, assignee=None, followers=None, components=None, tags=None):
        if components is not None:
            queue_components = self.st_client.queues[queue].components
            components = [component for component in queue_components if component['name'] in components]
        try:
            issue = self.st_client.issues.create(
                queue=queue,
                summary=summary,
                description=description,
                assignee=assignee or None,
                followers=followers or None,
                components=components or None,
                tags=tags or None
            )
        except Exception as e:
            logging.warn(f"Failed to create an issue with {type(e)}: {e}")
            return None
        else:
            logging.info(f"Created issue {issue.key}")
            return issue
