class YQLHelper():

    def __init__(self, yql_token):
        self.yql_token = yql_token

    def yql_query(self, query, yt_cluster):
        from yql.api.v1.client import YqlClient
        yql_client = YqlClient(db=yt_cluster, token=self.yql_token)
        request = yql_client.query(query)
        request.run()
        results = request.get_results()
        if not results.is_success:
            msg = "\n".join([str(err) for err in results.errors])
            raise Exception(f"Error when executing query {query}: {msg}")
        return results

    def get_bad_ad_inside_pages(
        self,
        yt_cluster,
        page_dsp_location,
        partner_page_location,
        page_location,
        tmp_folder,
        rows_limit,
        page_blacklist
    ):
        query = f"""
            pragma yt.TmpFolder = "{tmp_folder}";

            select distinct
                PartnerPage.Login as PartnerLogin,
                Page.PageID as PageID,
                Page.Name as PageName,
                PageDSP.PartnerShare as PartnerShare,
                1000000 as ExpectedPartnerShare
            from
                `{page_dsp_location}` as PageDSP
            inner join
                `{partner_page_location}` as PartnerPage on PageDSP.PageID = PartnerPage.PageID
            inner join
                `{page_location}` as Page on Page.PageID = PageDSP.PageID
            where
                (Page.OptionsYandexApp or Page.OptionsYandexGroup or Page.OptionsYandexPage) and
                PageDSP.DSPID != 10 and
                PageDSP.DSPID != 5 and
                PageDSP.PartnerShare != 1000000 and
                Page.PageID not in ({",".join(page_blacklist)})
            limit {rows_limit};
        """
        return self.yql_query(query, yt_cluster)
