from abc import ABCMeta, abstractmethod

import threading


class NanpuSUTAdapterInterface(object):

    __metaclass__ = ABCMeta

    @abstractmethod
    def get_nanpu_resource_path(self):
        pass

    @abstractmethod
    def get_logs_dir(self):
        pass

    @abstractmethod
    def get_base_dir(self):
        pass

    @abstractmethod
    def get_work_dir(self):
        pass

    @abstractmethod
    def get_base_iterator(self):
        pass

    @abstractmethod
    def get_cache_daemon_stub_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_executable_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_key_headers(self):
        pass


class BaseIterator(object):
    def __init__(self, resource_iterator, sync_resource_method):
        self._resource_iterator = resource_iterator
        self._sync_resource_method = sync_resource_method
        self._lock = threading.Lock()
        self._exhausted = False

    def next(self):
        with self._lock:
            try:
                resource = self._resource_iterator.next()
            except StopIteration:
                self._exhausted = True
                raise
        return self._sync_resource_method(resource)

    def is_exhausted(self):
        with self._lock:
            return self._exhausted
