from sandbox import sdk2

from sandbox.projects.yabs.nanpu.sut.adapters.interface import NanpuSUTAdapterInterface, BaseIterator
from parameters import NanpuSUTParameters
from sandbox.projects.yabs.nanpu.sut import NanpuSUT
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.sandboxsdk.paths import get_logs_folder, make_folder
from sandbox.projects.resource_types import CACHE_DAEMON

import os


class NanpuSUTSandboxAdapter(NanpuSUTAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    @staticmethod
    def get_init_parameters_class():
        return NanpuSUTParameters

    def get_nanpu_resource_path(self):
        return self.sync_resource(self.parameters.nanpu_resource)

    def get_logs_dir(self):
        return get_logs_folder()

    def get_base_dir(self):
        if self.parameters.tmpfs_size:
            return self.task_instance.ramdrive
        else:
            base_path = os.path.abspath('nanpu_bases')
            make_folder(base_path)
            return base_path

    def get_work_dir(self):
        return os.getcwd()

    def get_base_iterator(self):
        return BaseIterator(resource_iterator=iter(self.parameters.base_resources),
                            sync_resource_method=self.sync_resource)

    def get_cache_daemon_stub_path(self):
        return self.sync_resource(self.parameters.cache_daemon_stub_resource)

    def get_cache_daemon_executable_path(self):
        cache_daemon_executable_res_id = self.parameters.cache_daemon_stub_resource.cache_daemon_res_id
        return self.sync_resource(sdk2.Resource.find(CACHE_DAEMON, id=cache_daemon_executable_res_id).first())

    def get_cache_daemon_key_headers(self):
        return self.parameters.cache_daemon_stub_resource.key_header

    def get_cache_daemon_ports_map(self):
        return self.parameters.cache_daemon_ports_map

    def get_nanpu_port(self):
        return self.parameters.nanpu_port

    def create_module(self):
        return NanpuSUT(self)
