from sandbox import sdk2
from sandbox.projects.yabs.nanpu import BS_NANPU_RELEASE
from sandbox.projects.yabs.qa.resource_types import YABS_SERVER_CACHE_DAEMON_STUB_DATA

DEFAULT_PORTS_MAP = {
    'adfox': 46183,
    'laas': 39981,
    'lbs': 39337,
    'rtb': 44751,
}


class NanpuSUTParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("Nanpu SUT parameters:") as sut_group:
        tmpfs_size = sdk2.parameters.Integer('Tmpfs size', default_value=0)
        nanpu_resource = sdk2.parameters.Resource('Resource with nanpu package', resource_type=BS_NANPU_RELEASE, required=True)
        base_resources = sdk2.parameters.Resource('Base list', multiple=True)
        cache_daemon_stub_resource = sdk2.parameters.Resource('Cache daemon stub', resource_type=YABS_SERVER_CACHE_DAEMON_STUB_DATA)
        nanpu_port = sdk2.parameters.Integer('Nanpu port')
        cache_daemon_ports_map = sdk2.parameters.JSON('Ports for cachedaemon services', default=DEFAULT_PORTS_MAP)
