from sandbox.projects.yabs.nanpu.sut.adapters.interface import NanpuSUTAdapterInterface, BaseIterator
from sandbox.projects.yabs.nanpu.sut import NanpuSUT
from sandbox.projects.yabs.qa.adapter_base.standalone import StandaloneAdapterBase
from sandbox.common.rest import Client

import os
import shutil


class NanpuSUTStandaloneAdapter(NanpuSUTAdapterInterface, StandaloneAdapterBase):
    def __init__(self, parameters, logs_dir='logs', resource_cache_dir='resource_cache', work_dir='work_dir', base_dir='base_dir'):
        StandaloneAdapterBase.__init__(self, parameters, logs_dir, resource_cache_dir)
        self._client = Client()
        self._work_dir = work_dir
        if os.path.isdir(work_dir):
            shutil.rmtree(work_dir)
        os.makedirs(work_dir)
        self._base_dir = base_dir
        if os.path.isdir(self._base_dir):
            shutil.rmtree(base_dir)
        os.makedirs(self._base_dir)

    def get_nanpu_resource_path(self):
        return self.sync_resource(self.parameters.nanpu_resource)

    def get_logs_dir(self):
        return self._logs_dir

    def get_base_dir(self):
        return self._base_dir

    def get_work_dir(self):
        return self._work_dir

    def get_nanpu_port(self):
        return self.parameters.nanpu_port

    def get_base_iterator(self):
        return BaseIterator(resource_iterator=iter(self.parameters.base_resources),
                            sync_resource_method=self.sync_resource)

    def get_cache_daemon_stub_path(self):
        return self.sync_resource(self.parameters.cache_daemon_stub_resource)

    def get_cache_daemon_executable_path(self):
        cache_daemon_stub_resource_data = self._client.resource[self.parameters.cache_daemon_stub_resource].read()
        cache_daemon_executable_res_id = cache_daemon_stub_resource_data['attributes']['cache_daemon_res_id']
        return self.sync_resource(cache_daemon_executable_res_id)

    def get_cache_daemon_key_headers(self):
        cache_daemon_stub_resource_data = self._client.resource[self.parameters.cache_daemon_stub_resource].read()
        return cache_daemon_stub_resource_data['attributes']['key_header']

    def get_cache_daemon_ports_map(self):
        return self.parameters.cache_daemon_ports_map

    def create_module(self):
        return NanpuSUT(self)
