from response_differ import ResponseDiffer


import yt.wrapper as yt


@yt.with_context
class CompareDataReducer(object):
    def __init__(
        self,
        headers_to_replace,
        body_substitutes,
        base64_prefixes,
        entity_substitutes,
        logs_to_compare,
        log_fields_to_ignore,
        json_keys_to_delete,
        json_parsing_fields_re,
    ):
        self.headers_to_replace = headers_to_replace
        self.body_substitutes = body_substitutes
        self.base64_prefixes = base64_prefixes
        self.entity_substitutes = entity_substitutes
        self.logs_to_compare = logs_to_compare
        self.log_fields_to_ignore = log_fields_to_ignore
        self.json_keys_to_delete = json_keys_to_delete
        self.json_parsing_fields_re = json_parsing_fields_re

    def __call__(self, key, input_raw_iterator, context):
        preshoot_data = None
        patched_shoot_data = None

        for input_raw in input_raw_iterator:
            if context.table_index == 0:
                if preshoot_data is not None:
                    raise RuntimeError('More then one preshoot raw for one RequestID.')
                preshoot_data = input_raw['Data']
            elif context.table_index == 1:
                if patched_shoot_data is not None:
                    raise RuntimeError('More then one patched shoot raw for one RequestID.')
                patched_shoot_data = input_raw['Data']
            else:
                raise RuntimeError('Unknown table index.')

        assert preshoot_data is not None
        assert patched_shoot_data is not None

        response_differ = ResponseDiffer(
            self.headers_to_replace,
            self.body_substitutes,
            self.base64_prefixes,
            self.entity_substitutes,
            self.logs_to_compare,
            self.log_fields_to_ignore,
            self.json_keys_to_delete,
            self.json_parsing_fields_re,
            key['RequestID'],
        )
        (
            has_diff,
            status_diff,
            headers_diff,
            entities_diff,
            exts_diff,
            logs_diff,
            processing_type,
        ) = response_differ.diff_response_data(preshoot_data, patched_shoot_data)
        yield {
            'RequestID': key['RequestID'],
            'HasDiff': has_diff,
            'StatusDiff': status_diff,
            'HeadersDiff': headers_diff,
            'EntitiesDiff': entities_diff,
            'ExtsDiff': exts_diff,
            'LogsDiff': logs_diff,
            'ProcessingType': processing_type,
        }
