import base64
import json
import re
import sys
import traceback

from default_painting import PAINTING_MASK

from sandbox.projects.yabs.base_differ.base_response_differ import BaseResponseDiffer


class ResponseDiffer(BaseResponseDiffer):
    def __init__(
        self,
        headers_to_replace,
        body_substitutes,
        base64_prefixes,
        entity_substitutes,
        logs_to_compare,
        log_fields_to_ignore,
        json_keys_to_delete,
        json_parsing_fields_re,
        request_id,
    ):
        super(ResponseDiffer, self).__init__(headers_to_replace, body_substitutes, json_keys_to_delete, base64_prefixes)
        self.entity_substitutes = entity_substitutes
        self.logs_to_compare = logs_to_compare
        self.log_fields_to_ignore = log_fields_to_ignore
        self.json_parsing_fields_re = json_parsing_fields_re

        self.request_id = request_id

    def _try_parse_match_json(self, match):
        json_str = match.group()

        if len(json_str) > 0 and json_str[0] == '"':
            json_str = json_str[1:]
        if len(json_str) > 0 and json_str[-1] == '"':
            json_str = json_str[:-1]

        try:
            return json.dumps(json.loads(json_str), sort_keys=True)
        except:
            try:
                return json.dumps(json.loads(json_str.decode('string_escape')), sort_keys=True)
            except Exception, e:
                print >>sys.stderr, "_try_parse_match_json error: ", self.request_id, str(e), "\nJson String:", json_str

        return match.group()

    def _substitute_unparsed_json(self, entity, parsing_fields_re):
        for parsing_re in parsing_fields_re:
            try:
                entity = re.sub(str(parsing_re), self._try_parse_match_json, str(entity))
            except:
                pass
        return entity

    def _entities_diff(self, entity_pre, entity_post):
        def preprocess(entity, is_gzip):
            if is_gzip:
                self._decompress(entity)

            try:
                entity = base64.b64decode(entity)
            except:
                pass

            try:
                entity = self._replace_all_base64(entity, self.base64_prefixes, self.request_id)
            except:
                pass

            entity = self.apply_substituttes(entity, self.entity_substitutes)
            entity = self._substitute_unparsed_json(entity, self.json_parsing_fields_re)

            entity, is_json = self.try_to_json(entity)
            return entity, is_json

        entity_pre, is_pre_json = preprocess(entity_pre, self.is_pre_gzip)
        entity_post, is_post_json = preprocess(entity_post, self.is_test_gzip)

        if is_pre_json:
            entity_pre = self.json_painter.apply_json_paints(entity_pre)
        if is_post_json:
            entity_post = self.json_painter.apply_json_paints(entity_post)

        if is_pre_json and is_post_json:
            diff = self._dict_diff(entity_pre, entity_post)
        elif is_pre_json:
            diff = self._string_lists_diff([json.dumps(entity_pre)], [entity_post])
        elif is_post_json:
            diff = self._string_lists_diff([entity_pre], [json.dumps(entity_post)])
        else:
            diff = self._string_lists_diff(entity_pre.split('\n'), entity_post.split('\n'))

        return diff

    def _bodies_diff(self, body_pre, body_post):
        if self.is_pre_gzip:
            body_pre = self._decompress(body_pre)
        body_pre = self.apply_substituttes(body_pre, self.body_substitutes)

        if self.is_test_gzip:
            body_post = self._decompress(body_post)
        body_post = self.apply_substituttes(body_post, self.body_substitutes)

        if body_pre == body_post:
            processing_type = re.search(r'"ProcessingType":[ ]{0,1}"([A-Z_]*)",', body_pre)
            processing_type = processing_type.group(1) if processing_type is not None else 'NONE'
            return '', '', '', processing_type

        try:
            pre_json = json.loads(body_pre)
            post_json = json.loads(body_post)
        except:
            diff = self._string_lists_diff(body_pre.split('\n'), body_post.split('\n'))
            return diff, "", "", "JSON_FAIL"

        if 'exts' in pre_json.keys() and 'exts' in post_json.keys():
            exts_diff = self._dict_diff(pre_json['exts'], post_json['exts'])
        else:
            exts_diff = (
                'Missing "exts" section in one of responses!!!'
                if 'exts' in pre_json.keys() or 'exts' in post_json.keys()
                else ''
            )

        try:
            entities_diff = self._entities_diff(pre_json['entity'], post_json['entity'])
        except:
            entities_diff = 'Caught exception comparing entities.\n'
            entities_diff += traceback.format_exc()

        logs_diff = ''
        for log in self.logs_to_compare:
            pre_log = pre_json['logs'].get(log, {})
            post_log = post_json['logs'].get(log, {})

            for field in self.log_fields_to_ignore.get(log, []):
                pre_log[field] = PAINTING_MASK
                post_log[field] = PAINTING_MASK

            log_diff = self._dict_diff(pre_log, post_log)
            logs_diff += ('{logname} log diff:\n'.format(logname=log) + log_diff) if len(log_diff) else ''

        processing_type = pre_json['logs'].get('event', {}).get('ProcessingType', 'NONE')

        return entities_diff, exts_diff, logs_diff, processing_type

    def diff_response_data(self, response_pre, response_post):
        if response_pre == '' or response_post == '':
            return False, '', '', '', '', '', ''

        try:
            status_diff, headers_diff, body_pre, body_post = super(ResponseDiffer, self).diff_response_data(response_pre, response_post)
            entities_diff, exts_diff, logs_diff, processing_type = self._bodies_diff(body_pre, body_post)
        except:
            print >>sys.stderr, self.request_id
            raise

        has_diff = len(status_diff) + len(headers_diff) + len(entities_diff) + len(exts_diff) + len(logs_diff) > 0

        return has_diff, status_diff, headers_diff, entities_diff, exts_diff, logs_diff, processing_type
